/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.Decorator;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.AbandonRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.AddResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.BindResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.CompareResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.DeleteRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.DeleteResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultDoneDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultReferenceDecorator;
import org.apache.directory.shared.ldap.codec.decorators.UnbindRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.apache.directory.shared.ldap.model.message.UnbindRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageDecorator<E extends Message>
implements Message,
Decorator<E> {
    private final E decoratedMessage;
    private final Map<String, Control> controls;
    private CodecControl<? extends Control> currentControl;
    protected int messageLength;
    private int controlsLength;
    private final LdapCodecService codec;

    public static MessageDecorator<? extends Message> getDecorator(LdapCodecService codec, Message decoratedMessage) {
        if (decoratedMessage instanceof MessageDecorator) {
            return (MessageDecorator)decoratedMessage;
        }
        MessageDecorator decorator = null;
        switch (decoratedMessage.getType()) {
            case ABANDON_REQUEST: {
                decorator = new AbandonRequestDecorator(codec, (AbandonRequest)decoratedMessage);
                break;
            }
            case ADD_REQUEST: {
                decorator = new AddRequestDecorator(codec, (AddRequest)decoratedMessage);
                break;
            }
            case ADD_RESPONSE: {
                decorator = new AddResponseDecorator(codec, (AddResponse)decoratedMessage);
                break;
            }
            case BIND_REQUEST: {
                decorator = new BindRequestDecorator(codec, (BindRequest)decoratedMessage);
                break;
            }
            case BIND_RESPONSE: {
                decorator = new BindResponseDecorator(codec, (BindResponse)decoratedMessage);
                break;
            }
            case COMPARE_REQUEST: {
                decorator = new CompareRequestDecorator(codec, (CompareRequest)decoratedMessage);
                break;
            }
            case COMPARE_RESPONSE: {
                decorator = new CompareResponseDecorator(codec, (CompareResponse)decoratedMessage);
                break;
            }
            case DEL_REQUEST: {
                decorator = new DeleteRequestDecorator(codec, (DeleteRequest)decoratedMessage);
                break;
            }
            case DEL_RESPONSE: {
                decorator = new DeleteResponseDecorator(codec, (DeleteResponse)decoratedMessage);
                break;
            }
            case EXTENDED_REQUEST: {
                decorator = codec.decorate((ExtendedRequest)decoratedMessage);
                break;
            }
            case EXTENDED_RESPONSE: {
                decorator = codec.decorate((ExtendedResponse)decoratedMessage);
                break;
            }
            case INTERMEDIATE_RESPONSE: {
                decorator = new IntermediateResponseDecorator(codec, (IntermediateResponse)decoratedMessage);
                break;
            }
            case MODIFY_REQUEST: {
                decorator = new ModifyRequestDecorator(codec, (ModifyRequest)decoratedMessage);
                break;
            }
            case MODIFY_RESPONSE: {
                decorator = new ModifyResponseDecorator(codec, (ModifyResponse)decoratedMessage);
                break;
            }
            case MODIFYDN_REQUEST: {
                decorator = new ModifyDnRequestDecorator(codec, (ModifyDnRequest)decoratedMessage);
                break;
            }
            case MODIFYDN_RESPONSE: {
                decorator = new ModifyDnResponseDecorator(codec, (ModifyDnResponse)decoratedMessage);
                break;
            }
            case SEARCH_REQUEST: {
                decorator = new SearchRequestDecorator(codec, (SearchRequest)decoratedMessage);
                break;
            }
            case SEARCH_RESULT_DONE: {
                decorator = new SearchResultDoneDecorator(codec, (SearchResultDone)decoratedMessage);
                break;
            }
            case SEARCH_RESULT_ENTRY: {
                decorator = new SearchResultEntryDecorator(codec, (SearchResultEntry)decoratedMessage);
                break;
            }
            case SEARCH_RESULT_REFERENCE: {
                decorator = new SearchResultReferenceDecorator(codec, (SearchResultReference)decoratedMessage);
                break;
            }
            case UNBIND_REQUEST: {
                decorator = new UnbindRequestDecorator(codec, (UnbindRequest)decoratedMessage);
                break;
            }
            default: {
                return null;
            }
        }
        Map<String, Control> controls = decoratedMessage.getControls();
        if (controls != null) {
            for (Control control : controls.values()) {
                decorator.addControl(control);
            }
        }
        return decorator;
    }

    protected MessageDecorator(LdapCodecService codec, E decoratedMessage) {
        this.codec = codec;
        this.decoratedMessage = decoratedMessage;
        this.controls = new HashMap<String, Control>();
    }

    public void setControlsLength(int controlsLength) {
        this.controlsLength = controlsLength;
    }

    public int getControlsLength() {
        return this.controlsLength;
    }

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public CodecControl<? extends Control> getCurrentControl() {
        return this.currentControl;
    }

    @Override
    public MessageTypeEnum getType() {
        return this.decoratedMessage.getType();
    }

    @Override
    public Map<String, Control> getControls() {
        return this.controls;
    }

    @Override
    public Control getControl(String oid) {
        return this.controls.get(oid);
    }

    @Override
    public boolean hasControl(String oid) {
        return this.controls.containsKey(oid);
    }

    @Override
    public void addControl(Control control) throws MessageException {
        Control decorated;
        CodecControl<? extends Control> controlDecorator;
        if (control instanceof ControlDecorator) {
            controlDecorator = (CodecControl<? extends Control>)control;
            decorated = (Control)controlDecorator.getDecorated();
        } else {
            controlDecorator = this.codec.newControl(control);
            decorated = control;
        }
        this.decoratedMessage.addControl(decorated);
        this.controls.put(control.getOid(), controlDecorator);
        this.currentControl = controlDecorator;
    }

    @Override
    public void addAllControls(Control[] controls) throws MessageException {
        for (Control control : controls) {
            this.addControl(control);
        }
    }

    @Override
    public void removeControl(Control control) throws MessageException {
        this.decoratedMessage.removeControl(control);
        this.controls.remove(control.getOid());
    }

    @Override
    public int getMessageId() {
        return this.decoratedMessage.getMessageId();
    }

    @Override
    public Object get(Object key) {
        return this.decoratedMessage.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.decoratedMessage.put(key, value);
    }

    @Override
    public void setMessageId(int messageId) {
        this.decoratedMessage.setMessageId(messageId);
    }

    public String toString() {
        return this.decoratedMessage.toString();
    }

    @Override
    public E getDecorated() {
        return this.decoratedMessage;
    }

    @Override
    public LdapCodecService getCodecService() {
        return this.codec;
    }
}

