/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.api;

import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCodecServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapCodecServiceFactory.class);
    private static LdapCodecService ldapCodecService;
    private static boolean usingStandaloneImplementation;

    public static boolean isInitialized() {
        return ldapCodecService != null;
    }

    public static boolean isUsingStandaloneImplementation() {
        if (!LdapCodecServiceFactory.isInitialized()) {
            String msg = "Not initialized yet!";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        return usingStandaloneImplementation;
    }

    public static LdapCodecService getSingleton() {
        if (ldapCodecService == null) {
            LdapCodecServiceFactory.initialize(null);
        }
        return ldapCodecService;
    }

    public static void initialize(LdapCodecService ldapCodecService) {
        if (LdapCodecServiceFactory.ldapCodecService != null) {
            StringBuilder sb = new StringBuilder("The LdapCodecService is already set to an instance of ");
            sb.append(LdapCodecServiceFactory.class.getName());
            LOG.error(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        if (ldapCodecService == null) {
            try {
                Class<?> serviceClass = Class.forName("org.apache.directory.shared.ldap.codec.standalone.StandaloneLdapCodecService");
                LdapCodecServiceFactory.ldapCodecService = (LdapCodecService)serviceClass.newInstance();
                usingStandaloneImplementation = true;
            }
            catch (Exception e) {
                LOG.error("Failed to instantiate a viable instance, instantiating new instance of ", (Throwable)e);
            }
        } else {
            usingStandaloneImplementation = false;
            LdapCodecServiceFactory.ldapCodecService = ldapCodecService;
        }
    }
}

