/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.api;

import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.message.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlDecorator<E extends Control>
extends AbstractAsn1Object
implements CodecControl<E> {
    private E decorated;
    protected int valueLength;
    protected byte[] value;
    private LdapCodecService codec;

    public ControlDecorator(LdapCodecService codec, E decoratedControl) {
        this.decorated = decoratedControl;
        this.codec = codec;
    }

    @Override
    public E getDecorated() {
        return this.decorated;
    }

    public void setDecorated(E decorated) {
        this.decorated = decorated;
    }

    @Override
    public LdapCodecService getCodecService() {
        return this.codec;
    }

    @Override
    public String getOid() {
        return this.decorated.getOid();
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] value) {
        if (value != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            this.value = copy;
        } else {
            this.value = null;
        }
    }

    @Override
    public boolean isCritical() {
        return this.decorated.isCritical();
    }

    @Override
    public void setCritical(boolean criticality) {
        this.decorated.setCritical(criticality);
    }

    @Override
    public int computeLength() {
        return 0;
    }

    public int hashCode() {
        return this.decorated.hashCode();
    }

    public boolean equals(Object o) {
        if (this.decorated == null) {
            return o == null;
        }
        return this.decorated.equals(o);
    }

    public String toString() {
        return this.decorated.toString();
    }
}

