/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchResultEntry;

import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSearchResultAttributeValue
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultAttributeValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchResultAttributeValue() {
        super("Stores AttributeValue");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        if (tlv.getLength() == 0) {
            searchResultEntry.addAttributeValue("");
            LOG.debug("The attribute value is null");
        } else {
            if (container.isBinary(searchResultEntry.getCurrentAttribute().getId())) {
                value = tlv.getValue().getData();
                if (IS_DEBUG) {
                    LOG.debug("Attribute value {}", (Object)Strings.dumpBytes(value));
                }
            } else {
                value = Strings.utf8ToString(tlv.getValue().getData());
                LOG.debug("Attribute value {}", value);
            }
            searchResultEntry.addAttributeValue(value);
        }
        container.setGrammarEndAllowed(true);
    }
}

