/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.modifyRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreModifyRequestObjectName
extends GrammarAction<LdapMessageContainer<ModifyRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyRequestObjectName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyRequestObjectName() {
        super("Store Modify request object Name");
    }

    @Override
    public void action(LdapMessageContainer<ModifyRequestDecorator> container) throws DecoderException {
        ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
        ModifyRequest modifyRequest = (ModifyRequest)modifyRequestDecorator.getDecorated();
        TLV tlv = container.getCurrentTLV();
        Dn object = Dn.EMPTY_DN;
        if (tlv.getLength() == 0) {
            ((ModifyRequest)modifyRequestDecorator.getDecorated()).setName(object);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString(dnBytes);
            try {
                object = new Dn(dnStr);
            }
            catch (LdapInvalidDnException ine) {
                String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes(dnBytes) + ") is invalid";
                LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
                throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
            }
            modifyRequest.setName(object);
        }
        if (IS_DEBUG) {
            LOG.debug("Modification of Dn {}", (Object)modifyRequest.getName());
        }
    }
}

