/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.modifyDnRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreModifyDnRequestNewRdn
extends GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestNewRdn.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyDnRequestNewRdn() {
        super("Store ModifyDN request new RDN");
    }

    @Override
    public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Rdn newRdn = null;
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04090, new Object[0]);
            LOG.error(msg);
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), null);
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString(dnBytes);
        try {
            Dn dn = new Dn(dnStr);
            newRdn = dn.getRdn(0);
        }
        catch (LdapInvalidDnException ine) {
            String msg = "Invalid new Rdn given : " + dnStr + " (" + Strings.dumpBytes(dnBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
        }
        modifyDnRequest.setNewRdn(newRdn);
        if (IS_DEBUG) {
            LOG.debug("Modifying with new Rdn {}", (Object)newRdn);
        }
    }
}

