/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.ldapResult;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreResultCode
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreResultCode.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreResultCode() {
        super("Store resultCode");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        Value value = tlv.getValue();
        ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;
        try {
            resultCode = ResultCodeEnum.getResultCode(IntegerDecoder.parse(value, 0, ResultCodeEnum.UNKNOWN.getResultCode()));
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04018, Strings.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage());
        }
        switch (resultCode) {
            case SUCCESS: 
            case OPERATIONS_ERROR: 
            case PROTOCOL_ERROR: 
            case TIME_LIMIT_EXCEEDED: 
            case SIZE_LIMIT_EXCEEDED: 
            case COMPARE_FALSE: 
            case COMPARE_TRUE: 
            case AUTH_METHOD_NOT_SUPPORTED: 
            case STRONG_AUTH_REQUIRED: 
            case REFERRAL: 
            case ADMIN_LIMIT_EXCEEDED: 
            case UNAVAILABLE_CRITICAL_EXTENSION: 
            case CONFIDENTIALITY_REQUIRED: 
            case SASL_BIND_IN_PROGRESS: 
            case NO_SUCH_ATTRIBUTE: 
            case UNDEFINED_ATTRIBUTE_TYPE: 
            case INAPPROPRIATE_MATCHING: 
            case CONSTRAINT_VIOLATION: 
            case ATTRIBUTE_OR_VALUE_EXISTS: 
            case INVALID_ATTRIBUTE_SYNTAX: 
            case NO_SUCH_OBJECT: 
            case ALIAS_PROBLEM: 
            case INVALID_DN_SYNTAX: 
            case ALIAS_DEREFERENCING_PROBLEM: 
            case INAPPROPRIATE_AUTHENTICATION: 
            case INVALID_CREDENTIALS: 
            case INSUFFICIENT_ACCESS_RIGHTS: 
            case BUSY: 
            case UNAVAILABLE: 
            case UNWILLING_TO_PERFORM: 
            case LOOP_DETECT: 
            case NAMING_VIOLATION: 
            case OBJECT_CLASS_VIOLATION: 
            case NOT_ALLOWED_ON_NON_LEAF: 
            case NOT_ALLOWED_ON_RDN: 
            case ENTRY_ALREADY_EXISTS: 
            case AFFECTS_MULTIPLE_DSAS: 
            case CANCELED: 
            case CANNOT_CANCEL: 
            case TOO_LATE: 
            case NO_SUCH_OPERATION: {
                break;
            }
            default: {
                LOG.warn("The resultCode " + (Object)((Object)resultCode) + " is unknown.");
                resultCode = ResultCodeEnum.OTHER;
            }
        }
        if (IS_DEBUG) {
            LOG.debug("The result code is set to " + (Object)((Object)resultCode));
        }
        ResultResponse response = (ResultResponse)((Object)container.getMessage());
        LdapResult ldapResult = response.getLdapResult();
        ldapResult.setResultCode(resultCode);
    }
}

