/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.intermediateResponse;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.util.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreIntermediateResponseName
extends GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIntermediateResponseName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreIntermediateResponseName() {
        super("Store response name");
    }

    @Override
    public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
        IntermediateResponse intermediateResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04095, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] responseNameBytes = tlv.getValue().getData();
        String oidStr = Strings.utf8ToString(responseNameBytes);
        if (!OID.isOID(oidStr)) {
            String msg = "The Intermediate Response name is not a valid OID : " + Strings.utf8ToString(responseNameBytes) + " (" + Strings.dumpBytes(responseNameBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)oidStr);
            throw new DecoderException(msg);
        }
        OID.isOID(oidStr);
        intermediateResponse.setResponseName(oidStr);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("OID read : {}", (Object)intermediateResponse.getResponseName());
        }
    }
}

