/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.extendedRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.util.StringConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreExtendedRequestValue
extends GrammarAction<LdapMessageContainer<ExtendedRequestDecorator<?, ?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreExtendedRequestValue() {
        super("Store ExtendedRequest value");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedRequestDecorator<?, ?>> container) throws DecoderException {
        ExtendedRequestDecorator<?, ?> extendedRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            extendedRequest.setRequestValue(StringConstants.EMPTY_BYTES);
        } else {
            extendedRequest.setRequestValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Extended value : {}", (Object)extendedRequest.getRequestValue());
        }
    }
}

