/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.controls;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.util.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddControl
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddControl.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddControl() {
        super("Add a new control");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04097, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] value = tlv.getValue().getData();
        String oidValue = Strings.asciiBytesToString(value);
        if (!OID.isOID(oidValue)) {
            LOG.error(I18n.err(I18n.ERR_04098, Strings.dumpBytes(value)));
            throw new DecoderException(I18n.err(I18n.ERR_04099, oidValue));
        }
        MessageDecorator<? extends Message> message = container.getMessage();
        CodecControl<? extends Control> control = container.getLdapCodecService().newControl(oidValue);
        message.addControl(control);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Control OID : " + oidValue);
        }
    }
}

