/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.Permission;
import org.apache.directory.shared.ldap.aci.UserClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPermission
extends Permission {
    private final Collection<UserClass> userClasses;

    public ItemPermission(Integer precedence, Collection<GrantAndDenial> grantsAndDenials, Collection<UserClass> userClasses) {
        super(precedence, grantsAndDenials);
        this.userClasses = Collections.unmodifiableCollection(new ArrayList<UserClass>(userClasses));
    }

    public Collection<UserClass> getUserClasses() {
        return this.userClasses;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        if (this.getPrecedence() != null) {
            buffer.append("precedence ");
            buffer.append(this.getPrecedence());
            buffer.append(", ");
        }
        buffer.append("userClasses { ");
        boolean isFirst = true;
        for (UserClass userClass : this.userClasses) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(userClass.toString());
        }
        buffer.append(" }, grantsAndDenials { ");
        isFirst = true;
        for (GrantAndDenial grantAndDenial : this.getGrantsAndDenials()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(grantAndDenial.toString());
        }
        buffer.append(" } }");
        return buffer.toString();
    }
}

