/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestDsml
extends AbstractResultResponseRequestDsml<ModifyRequest, ModifyResponse>
implements ModifyRequest {
    private EntryAttribute currentAttribute;
    private ModificationOperation currentOperation;

    public ModifyRequestDsml(LdapCodecService codec) {
        super(codec, new ModifyRequestImpl());
    }

    public ModifyRequestDsml(LdapCodecService codec, ModifyRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = ModificationOperation.getOperation(currentOperation);
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new DefaultEntryAttribute(type);
        DefaultModification modification = new DefaultModification(this.currentOperation, this.currentAttribute);
        ((ModifyRequest)this.getDecorated()).addModification(modification);
    }

    public void addAttributeValue(byte[] value) {
        this.currentAttribute.add(new byte[][]{value});
    }

    public void addAttributeValue(String value) {
        this.currentAttribute.add(value);
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        ModifyRequest request = (ModifyRequest)this.getDecorated();
        if (request.getName() != null) {
            element.addAttribute("dn", request.getName().getName());
        }
        Collection<Modification> modifications = request.getModifications();
        for (Modification modification : modifications) {
            ModificationOperation operation;
            Element modElement = element.addElement("modification");
            if (modification.getAttribute() != null) {
                modElement.addAttribute("name", modification.getAttribute().getId());
                Iterator<Value<?>> iterator = modification.getAttribute().getAll();
                while (iterator.hasNext()) {
                    Value<?> value = iterator.next();
                    if (value.get() == null) continue;
                    if (ParserUtils.needsBase64Encoding(value.get())) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                        element.getDocument().getRootElement().add(xsdNamespace);
                        element.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = modElement.addElement("value").addText(ParserUtils.base64Encode(value.get()));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                        continue;
                    }
                    modElement.addElement("value").setText(value.getString());
                }
            }
            if ((operation = modification.getOperation()) == ModificationOperation.ADD_ATTRIBUTE) {
                modElement.addAttribute("operation", "add");
                continue;
            }
            if (operation == ModificationOperation.REPLACE_ATTRIBUTE) {
                modElement.addAttribute("operation", "replace");
                continue;
            }
            if (operation != ModificationOperation.REMOVE_ATTRIBUTE) continue;
            modElement.addAttribute("operation", "delete");
        }
        return element;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((ModifyRequest)this.getDecorated()).getResponseType();
    }

    @Override
    public Dn getName() {
        return ((ModifyRequest)this.getDecorated()).getName();
    }

    @Override
    public void setName(Dn name) {
        ((ModifyRequest)this.getDecorated()).setName(name);
    }

    @Override
    public Collection<Modification> getModifications() {
        return ((ModifyRequest)this.getDecorated()).getModifications();
    }

    @Override
    public void addModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).addModification(mod);
    }

    @Override
    public void removeModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).removeModification(mod);
    }

    @Override
    public void remove(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
    }

    @Override
    public void remove(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
    }

    @Override
    public void remove(EntryAttribute attr) {
        ((ModifyRequest)this.getDecorated()).remove(attr);
    }

    @Override
    public void addModification(EntryAttribute attr, ModificationOperation modOp) {
        ((ModifyRequest)this.getDecorated()).addModification(attr, modOp);
    }

    @Override
    public void add(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
    }

    @Override
    public void add(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
    }

    @Override
    public void add(EntryAttribute attr) {
        ((ModifyRequest)this.getDecorated()).add(attr);
    }

    @Override
    public void replace(String attributeName) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName);
    }

    @Override
    public void replace(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
    }

    @Override
    public void replace(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
    }

    @Override
    public void replace(EntryAttribute attr) {
        ((ModifyRequest)this.getDecorated()).replace(attr);
    }
}

