/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import org.apache.directory.shared.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDNRequestDsml
extends AbstractResultResponseRequestDsml<ModifyDnRequest, ModifyDnResponse>
implements ModifyDnRequest {
    public ModifyDNRequestDsml(LdapCodecService codec) {
        super(codec, new ModifyDnRequestImpl());
    }

    public ModifyDNRequestDsml(LdapCodecService codec, ModifyDnRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((ModifyDnRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        ModifyDnRequest request = (ModifyDnRequest)this.getDecorated();
        if (request.getName() != null) {
            element.addAttribute("dn", request.getName().getName());
        }
        if (request.getNewRdn() != null) {
            element.addAttribute("newrdn", request.getNewRdn().getName());
        }
        element.addAttribute("deleteoldrdn", request.getDeleteOldRdn() ? "true" : "false");
        if (request.getNewRdn() != null) {
            element.addAttribute("newSuperior", request.getNewSuperior().getName());
        }
        return element;
    }

    @Override
    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    public void setEntry(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
    }

    public boolean isDeleteOldRDN() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    public void setDeleteOldRDN(boolean deleteOldRDN) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRDN);
    }

    public Rdn getNewRDN() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    public void setNewRDN(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
    }

    @Override
    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    @Override
    public void setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((ModifyDnRequest)this.getDecorated()).getResponseType();
    }

    @Override
    public void setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
    }

    @Override
    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    @Override
    public void setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
    }

    @Override
    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    @Override
    public void setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
    }

    @Override
    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }
}

