/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import org.apache.directory.shared.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareRequestDsml
extends AbstractResultResponseRequestDsml<CompareRequest, CompareResponse>
implements CompareRequest {
    public CompareRequestDsml(LdapCodecService codec) {
        super(codec, new CompareRequestImpl());
    }

    public CompareRequestDsml(LdapCodecService codec, CompareRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((CompareRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        CompareRequest request = (CompareRequest)this.getDecorated();
        if (request.getName() != null) {
            element.addAttribute("dn", request.getName().getName());
        }
        Element assertionElement = element.addElement("assertion");
        if (request.getAttributeId() != null) {
            assertionElement.addAttribute("name", request.getAttributeId());
        }
        if (request.getAssertionValue() != null) {
            assertionElement.addElement("value").setText(request.getAssertionValue().getString());
        }
        return element;
    }

    @Override
    public Dn getName() {
        return ((CompareRequest)this.getDecorated()).getName();
    }

    @Override
    public void setName(Dn entry) {
        ((CompareRequest)this.getDecorated()).setName(entry);
    }

    public void setAssertionValue(Object assertionValue) {
        if (assertionValue instanceof String) {
            ((CompareRequest)this.getDecorated()).setAssertionValue((String)assertionValue);
        } else {
            ((CompareRequest)this.getDecorated()).setAssertionValue((byte[])assertionValue);
        }
    }

    public String getAttributeDesc() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    public void setAttributeDesc(String attributeDesc) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attributeDesc);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((CompareRequest)this.getDecorated()).getResponseType();
    }

    @Override
    public void setAssertionValue(String value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
    }

    @Override
    public void setAssertionValue(byte[] value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
    }

    @Override
    public String getAttributeId() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    @Override
    public void setAttributeId(String attrId) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attrId);
    }

    @Override
    public Value<?> getAssertionValue() {
        return ((CompareRequest)this.getDecorated()).getAssertionValue();
    }
}

