/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.ldap.model.message.Request;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRequestDsml {
    private List<DsmlDecorator<? extends Request>> requests = new ArrayList<DsmlDecorator<? extends Request>>();
    private int requestID;
    private Processing processing;
    private OnError onError;
    private ResponseOrder responseOrder = ResponseOrder.SEQUENTIAL;

    public BatchRequestDsml() {
        this.processing = Processing.SEQUENTIAL;
        this.onError = OnError.EXIT;
    }

    public DsmlDecorator<? extends Request> getCurrentRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    public boolean addRequest(DsmlDecorator<? extends Request> request) {
        return this.requests.add(request);
    }

    public boolean removeRequest(DsmlDecorator<? extends Request> request) {
        return this.requests.remove(request);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public void setProcessing(Processing processing) {
        this.processing = processing;
    }

    public OnError getOnError() {
        return this.onError;
    }

    public void setOnError(OnError onError) {
        this.onError = onError;
    }

    public ResponseOrder getResponseOrder() {
        return this.responseOrder;
    }

    public void setResponseOrder(ResponseOrder responseOrder) {
        this.responseOrder = responseOrder;
    }

    public List<DsmlDecorator<? extends Request>> getRequests() {
        return this.requests;
    }

    public String toDsml() {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("batchRequest");
        if (this.requestID != 0) {
            element.addAttribute("requestID", "" + this.requestID);
        }
        if (this.responseOrder == ResponseOrder.UNORDERED) {
            element.addAttribute("responseOrder", "unordered");
        }
        if (this.processing == Processing.PARALLEL) {
            element.addAttribute("processing", "parallel");
        }
        if (this.onError == OnError.RESUME) {
            element.addAttribute("onError", "resume");
        }
        for (DsmlDecorator<? extends Request> request : this.requests) {
            request.toDsml(element);
        }
        return ParserUtils.styleDocument(document).asXML();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("processing: " + (Object)((Object)this.processing));
        sb.append(" - ");
        sb.append("onError: " + (Object)((Object)this.onError));
        sb.append(" - ");
        sb.append("responseOrder: " + (Object)((Object)this.responseOrder));
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseOrder {
        SEQUENTIAL,
        UNORDERED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnError {
        RESUME,
        EXIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Processing {
        SEQUENTIAL,
        PARALLEL;

    }
}

