/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractRequestDsml;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.message.AbandonListener;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.message.ResultResponseRequest;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultResponseRequestDsml<E extends ResultResponseRequest<F>, F extends ResultResponse>
extends AbstractRequestDsml<E>
implements ResultResponseRequest<F>,
AbandonableRequest {
    public AbstractResultResponseRequestDsml(LdapCodecService codec, E ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public Element toDsml(Element root) {
        Element element = root.addElement(this.getRequestName());
        int requestID = ((ResultResponseRequest)this.getDecorated()).getMessageId();
        if (requestID > 0) {
            element.addAttribute("requestID", "" + requestID);
        }
        ParserUtils.addControls(this.getCodecService(), element, ((ResultResponseRequest)this.getDecorated()).getControls().values());
        return element;
    }

    private String getRequestName() {
        switch (((ResultResponseRequest)this.getDecorated()).getType()) {
            case ABANDON_REQUEST: {
                return "abandonRequest";
            }
            case ADD_REQUEST: {
                return "addRequest";
            }
            case BIND_REQUEST: {
                return "authRequest";
            }
            case COMPARE_REQUEST: {
                return "compareRequest";
            }
            case DEL_REQUEST: {
                return "delRequest";
            }
            case EXTENDED_REQUEST: {
                return "extendedRequest";
            }
            case MODIFYDN_REQUEST: {
                return "modDNRequest";
            }
            case MODIFY_REQUEST: {
                return "modifyRequest";
            }
            case SEARCH_REQUEST: {
                return "searchRequest";
            }
        }
        return "error";
    }

    @Override
    public int computeLength() {
        return 0;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        return null;
    }

    @Override
    public F getResultResponse() {
        return (F)((ResultResponseRequest)this.getDecorated()).getResultResponse();
    }

    @Override
    public void abandon() {
        ((AbandonableRequest)this.getDecorated()).abandon();
    }

    @Override
    public boolean isAbandoned() {
        return ((AbandonableRequest)this.getDecorated()).isAbandoned();
    }

    @Override
    public void addAbandonListener(AbandonListener listener) {
        ((AbandonableRequest)this.getDecorated()).addAbandonListener(listener);
    }
}

