/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.reponse.AbstractResponseDsml;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultEntryDsml
extends AbstractResponseDsml<SearchResultEntry>
implements SearchResultEntry {
    private EntryAttribute currentAttribute;

    public SearchResultEntryDsml(LdapCodecService codec) {
        super(codec, new SearchResultEntryImpl());
    }

    public SearchResultEntryDsml(LdapCodecService codec, SearchResultEntry ldapMessage) {
        super(codec, ldapMessage);
    }

    public EntryAttribute getCurrentAttribute() {
        return this.currentAttribute;
    }

    public void addAttribute(String type) throws LdapException {
        this.currentAttribute = new DefaultEntryAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(this.currentAttribute);
    }

    public void addAttributeValue(Object value) {
        if (value instanceof String) {
            this.currentAttribute.add((String)value);
        } else {
            this.currentAttribute.add(new byte[][]{(byte[])value});
        }
    }

    @Override
    public MessageTypeEnum getType() {
        return ((SearchResultEntry)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = root.addElement("searchResultEntry");
        SearchResultEntry searchResultEntry = (SearchResultEntry)this.getDecorated();
        element.addAttribute("dn", searchResultEntry.getObjectName().getName());
        Entry entry = searchResultEntry.getEntry();
        for (EntryAttribute attribute : entry) {
            Element attributeElement = element.addElement("attr");
            attributeElement.addAttribute("name", attribute.getUpId());
            for (Value value : attribute) {
                if (ParserUtils.needsBase64Encoding(value.get())) {
                    Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                    Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                    attributeElement.getDocument().getRootElement().add(xsdNamespace);
                    attributeElement.getDocument().getRootElement().add(xsiNamespace);
                    Element valueElement = attributeElement.addElement("value").addText(ParserUtils.base64Encode(value.get()));
                    valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                    continue;
                }
                attributeElement.addElement("value").addText(value.getString());
            }
        }
        return element;
    }

    @Override
    public Dn getObjectName() {
        return ((SearchResultEntry)this.getDecorated()).getObjectName();
    }

    @Override
    public void setObjectName(Dn objectName) {
        ((SearchResultEntry)this.getDecorated()).setObjectName(objectName);
    }

    @Override
    public Entry getEntry() {
        return ((SearchResultEntry)this.getDecorated()).getEntry();
    }

    @Override
    public void setEntry(Entry entry) {
        ((SearchResultEntry)this.getDecorated()).setEntry(entry);
    }
}

