/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.ldap.model.message.Response;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResponseDsml {
    private List<DsmlDecorator<? extends Response>> responses = new ArrayList<DsmlDecorator<? extends Response>>();
    private int requestID;

    public DsmlDecorator<? extends Response> getCurrentResponse() {
        return this.responses.get(this.responses.size() - 1);
    }

    public boolean addResponse(DsmlDecorator<? extends Response> response) {
        return this.responses.add(response);
    }

    public boolean removeResponse(DsmlDecorator<Response> response) {
        return this.responses.remove(response);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public List<DsmlDecorator<? extends Response>> getResponses() {
        return this.responses;
    }

    public String toDsml() {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("batchResponse");
        if (this.requestID != 0) {
            element.addAttribute("requestID", "" + this.requestID);
        }
        for (DsmlDecorator<? extends Response> response : this.responses) {
            response.toDsml(element);
        }
        return ParserUtils.styleDocument(document).asXML();
    }
}

