/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.Dsmlv2Parser;
import org.apache.directory.shared.dsmlv2.reponse.AddResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.BatchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.BindResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.CompareResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.DelResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ErrorResponse;
import org.apache.directory.shared.dsmlv2.reponse.ExtendedResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ModDNResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ModifyResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultEntryDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultReferenceDsml;
import org.apache.directory.shared.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.shared.dsmlv2.request.Dsmlv2Grammar;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindRequestImpl;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.Request;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dsmlv2Engine {
    private String user;
    private String password;
    private LdapConnection connection;
    private Dsmlv2Parser parser;
    private boolean continueOnError;
    private boolean exit = false;
    private BatchRequestDsml batchRequest;
    private BatchResponseDsml batchResponse;
    private Dsmlv2Grammar grammar = new Dsmlv2Grammar();

    public Dsmlv2Engine(String host, int port, String user, String password) {
        this.user = user;
        this.password = password;
        this.connection = new LdapNetworkConnection(host, port);
    }

    public String processDSML(String dsmlInput) throws XmlPullParserException {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInput(dsmlInput);
        return this.processDSML();
    }

    public String processDSMLFile(String fileName) throws XmlPullParserException, FileNotFoundException {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInputFile(fileName);
        return this.processDSML();
    }

    public String processDSML(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.parser = new Dsmlv2Parser(this.grammar);
        this.parser.setInput(inputStream, inputEncoding);
        return this.processDSML();
    }

    private String processDSML() {
        this.batchResponse = new BatchResponseDsml();
        try {
            this.bind(1);
        }
        catch (Exception e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT, e.getLocalizedMessage());
            this.batchResponse.addResponse(errorResponse);
            return this.batchResponse.toDsml();
        }
        try {
            this.processBatchRequest();
        }
        catch (XmlPullParserException e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err(I18n.ERR_03001, e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
            this.batchResponse.addResponse(errorResponse);
            return this.batchResponse.toDsml();
        }
        DsmlDecorator<? extends Request> request = null;
        try {
            request = this.parser.getNextRequest();
        }
        catch (XmlPullParserException e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err(I18n.ERR_03001, e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
            this.batchResponse.addResponse(errorResponse);
            return this.batchResponse.toDsml();
        }
        while (request != null) {
            if (this.batchRequest.getProcessing().equals((Object)BatchRequestDsml.Processing.PARALLEL) && this.batchRequest.getResponseOrder().equals((Object)BatchRequestDsml.ResponseOrder.UNORDERED) && request.getDecorated().getMessageId() <= 0) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err(I18n.ERR_03002, new Object[0]));
                this.batchResponse.addResponse(errorResponse);
                return this.batchResponse.toDsml();
            }
            try {
                this.processRequest(request);
            }
            catch (Exception e) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR, I18n.err(I18n.ERR_03003, e.getMessage()));
                this.batchResponse.addResponse(errorResponse);
                return this.batchResponse.toDsml();
            }
            if (this.exit) break;
            try {
                request = this.parser.getNextRequest();
            }
            catch (XmlPullParserException e) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err(I18n.ERR_03001, e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
                this.batchResponse.addResponse(errorResponse);
                return this.batchResponse.toDsml();
            }
        }
        return this.batchResponse.toDsml();
    }

    private void processRequest(DsmlDecorator<? extends Request> request) throws Exception {
        Object resultCode = null;
        switch (request.getDecorated().getType()) {
            case ABANDON_REQUEST: {
                this.connection.abandon((AbandonRequest)((Object)request));
                return;
            }
            case ADD_REQUEST: {
                AddResponse response = this.connection.add((AddRequest)((Object)request));
                AddResponseDsml addResponseDsml = new AddResponseDsml(this.connection.getCodecService(), response);
                this.batchResponse.addResponse(addResponseDsml);
                break;
            }
            case BIND_REQUEST: {
                BindResponse bindResponse = this.connection.bind((BindRequest)((Object)request));
                BindResponseDsml authResponseDsml = new BindResponseDsml(this.connection.getCodecService(), bindResponse);
                this.batchResponse.addResponse(authResponseDsml);
                break;
            }
            case COMPARE_REQUEST: {
                CompareResponse compareResponse = this.connection.compare((CompareRequest)((Object)request));
                CompareResponseDsml compareResponseDsml = new CompareResponseDsml(this.connection.getCodecService(), compareResponse);
                this.batchResponse.addResponse(compareResponseDsml);
                break;
            }
            case DEL_REQUEST: {
                DeleteResponse delResponse = this.connection.delete((DeleteRequest)((Object)request));
                DelResponseDsml delResponseDsml = new DelResponseDsml(this.connection.getCodecService(), delResponse);
                this.batchResponse.addResponse(delResponseDsml);
                break;
            }
            case EXTENDED_REQUEST: {
                ExtendedResponse extendedResponse = this.connection.extended((ExtendedRequest)((Object)request));
                ExtendedResponseDsml extendedResponseDsml = new ExtendedResponseDsml(this.connection.getCodecService(), extendedResponse);
                this.batchResponse.addResponse(extendedResponseDsml);
                break;
            }
            case MODIFY_REQUEST: {
                ModifyResponse modifyResponse = this.connection.modify((ModifyRequest)((Object)request));
                ModifyResponseDsml modifyResponseDsml = new ModifyResponseDsml(this.connection.getCodecService(), modifyResponse);
                this.batchResponse.addResponse(modifyResponseDsml);
                break;
            }
            case MODIFYDN_REQUEST: {
                ModifyDnResponse modifyDnResponse = this.connection.modifyDn((ModifyDnRequest)((Object)request));
                ModDNResponseDsml modDNResponseDsml = new ModDNResponseDsml(this.connection.getCodecService(), modifyDnResponse);
                this.batchResponse.addResponse(modDNResponseDsml);
                break;
            }
            case SEARCH_REQUEST: {
                SearchCursor searchResponses = this.connection.search((SearchRequest)((Object)request));
                while (searchResponses.next()) {
                    Response searchResponse = (Response)searchResponses.get();
                    SearchResponseDsml searchResponseDsml = null;
                    int requestID = searchResponse.getMessageId();
                    if (searchResponse.getType() == MessageTypeEnum.SEARCH_RESULT_ENTRY) {
                        SearchResultEntry searchResultEntry = (SearchResultEntry)searchResponse;
                        SearchResultEntryDsml searchResultEntryDsml = new SearchResultEntryDsml(this.connection.getCodecService(), searchResultEntry);
                        searchResponseDsml = new SearchResponseDsml(this.connection.getCodecService(), searchResultEntryDsml);
                        if (requestID > 0) {
                            searchResponseDsml.setMessageId(requestID);
                        }
                        searchResponseDsml.addResponse(searchResultEntryDsml);
                    } else if (searchResponse.getType() == MessageTypeEnum.SEARCH_RESULT_REFERENCE) {
                        SearchResultReference searchResultReference = (SearchResultReference)searchResponse;
                        SearchResultReferenceDsml searchResultReferenceDsml = new SearchResultReferenceDsml(this.connection.getCodecService(), searchResultReference);
                        searchResponseDsml = new SearchResponseDsml(this.connection.getCodecService(), searchResultReferenceDsml);
                        if (requestID > 0) {
                            searchResponseDsml.setMessageId(requestID);
                        }
                        searchResponseDsml.addResponse(searchResultReferenceDsml);
                    }
                    this.batchResponse.addResponse(searchResponseDsml);
                }
                break;
            }
            case UNBIND_REQUEST: {
                this.connection.unBind();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected request tpye " + (Object)((Object)request.getDecorated().getType()));
            }
        }
        if (!this.continueOnError && resultCode != ResultCodeEnum.SUCCESS && resultCode != ResultCodeEnum.COMPARE_TRUE && resultCode != ResultCodeEnum.COMPARE_FALSE && resultCode != ResultCodeEnum.REFERRAL) {
            this.exit = true;
        }
    }

    private void processBatchRequest() throws XmlPullParserException {
        this.parser.parseBatchRequest();
        this.batchRequest = this.parser.getBatchRequest();
        if (BatchRequestDsml.OnError.RESUME.equals((Object)this.batchRequest.getOnError())) {
            this.continueOnError = true;
        } else if (BatchRequestDsml.OnError.EXIT.equals((Object)this.batchRequest.getOnError())) {
            this.continueOnError = false;
        }
        if (this.batchRequest.getRequestID() != 0) {
            this.batchResponse.setRequestID(this.batchRequest.getRequestID());
        }
    }

    private void bind(int messageId) throws LdapException, EncoderException, DecoderException, IOException {
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setSimple(true);
        bindRequest.setCredentials(Strings.getBytesUtf8(this.password));
        bindRequest.setName(new Dn(this.user));
        bindRequest.setVersion3(true);
        bindRequest.setMessageId(messageId);
        BindResponse bindResponse = this.connection.bind(bindRequest);
        if (bindResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            System.err.println("Error : " + bindResponse.getLdapResult().getErrorMessage());
        }
    }
}

