/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.dsmlv2.reponse.BatchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.Dsmlv2ResponseGrammar;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.message.Response;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dsmlv2ResponseParser {
    private Dsmlv2Container container;

    public Dsmlv2ResponseParser(LdapCodecService codec) throws XmlPullParserException {
        this.container = new Dsmlv2Container(codec);
        this.container.setGrammar(Dsmlv2ResponseGrammar.getInstance());
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        this.container.setParser(xpp);
    }

    public void setInput(String str) throws XmlPullParserException {
        this.container.getParser().setInput((Reader)new StringReader(str));
    }

    public void setInputFile(String fileName) throws FileNotFoundException, XmlPullParserException {
        FileReader reader = new FileReader(fileName);
        this.container.getParser().setInput((Reader)reader);
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.container.getParser().setInput(inputStream, inputEncoding);
    }

    public void parse() throws XmlPullParserException, IOException {
        Dsmlv2ResponseGrammar grammar = Dsmlv2ResponseGrammar.getInstance();
        grammar.executeAction(this.container);
    }

    public void parseBatchResponse() throws XmlPullParserException {
        XmlPullParser xpp = this.container.getParser();
        int eventType = xpp.getEventType();
        do {
            if (eventType == 0) {
                this.container.setState(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE);
            } else if (eventType == 1) {
                this.container.setState(Dsmlv2StatesEnum.GRAMMAR_END);
            } else if (eventType == 2) {
                Dsmlv2ResponseParser.processTag(this.container, 0);
            } else if (eventType == 3) {
                Dsmlv2ResponseParser.processTag(this.container, 1);
            }
            try {
                eventType = xpp.next();
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03037, e.getLocalizedMessage()), xpp, null);
            }
        } while (this.container.getState() != Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP);
    }

    private static void processTag(Dsmlv2Container container, int tagType) throws XmlPullParserException {
        XmlPullParser xpp = container.getParser();
        String tagName = xpp.getName().toLowerCase();
        GrammarTransition transition = container.getTransition(container.getState(), new Tag(tagName, tagType));
        if (transition != null) {
            container.setState(transition.getNextState());
            if (transition.hasAction()) {
                transition.getAction().action(container);
            }
        } else {
            throw new XmlPullParserException(I18n.err(I18n.ERR_03036, new Tag(tagName, tagType)), xpp, null);
        }
    }

    public BatchResponseDsml getBatchResponse() {
        return this.container.getBatchResponse();
    }

    public DsmlDecorator<? extends Response> getNextResponse() throws XmlPullParserException {
        if (this.container.getBatchResponse() == null) {
            this.parseBatchResponse();
        }
        XmlPullParser xpp = this.container.getParser();
        int eventType = xpp.getEventType();
        while (true) {
            if (eventType == 4) {
                try {
                    xpp.next();
                }
                catch (IOException e) {
                    throw new XmlPullParserException(I18n.err(I18n.ERR_03037, e.getLocalizedMessage()), xpp, null);
                }
                eventType = xpp.getEventType();
                continue;
            }
            if (eventType == 0) {
                this.container.setState(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE);
            } else {
                if (eventType == 1) {
                    this.container.setState(Dsmlv2StatesEnum.GRAMMAR_END);
                    return null;
                }
                if (eventType == 2) {
                    Dsmlv2ResponseParser.processTag(this.container, 0);
                } else if (eventType == 3) {
                    Dsmlv2ResponseParser.processTag(this.container, 1);
                }
            }
            try {
                eventType = xpp.next();
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err(I18n.ERR_03037, e.getLocalizedMessage()), xpp, null);
            }
            if (this.container.getState() == Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP) break;
        }
        return this.container.getBatchResponse().getCurrentResponse();
    }

    public void parseAllResponses() throws XmlPullParserException {
        while (this.getNextResponse() != null) {
        }
    }
}

