/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.message.Control;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsmlControl<E extends Control>
implements Control,
DsmlDecorator<E> {
    private E decorated;
    protected byte[] value;
    private LdapCodecService codec;

    public DsmlControl(LdapCodecService codec, E decorated) {
        this.codec = codec;
        this.decorated = decorated;
    }

    public LdapCodecService getCodecService() {
        return this.codec;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value != null) {
            byte[] copy = new byte[value.length];
            System.arraycopy(value, 0, copy, 0, value.length);
            this.value = copy;
        } else {
            this.value = null;
        }
    }

    @Override
    public String getOid() {
        return this.decorated.getOid();
    }

    @Override
    public boolean isCritical() {
        return this.decorated.isCritical();
    }

    @Override
    public void setCritical(boolean isCritical) {
        this.decorated.setCritical(isCritical);
    }

    @Override
    public Element toDsml(Element root) {
        return null;
    }

    @Override
    public E getDecorated() {
        return this.decorated;
    }
}

