/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.io.IOException;
import java.util.HashMap;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.shared.dsmlv2.Grammar;
import org.apache.directory.shared.dsmlv2.GrammarAction;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.i18n.I18n;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrammar
implements Grammar {
    protected HashMap<Tag, GrammarTransition>[] transitions;
    protected String name;
    protected Enum<Dsmlv2StatesEnum>[] statesEnum;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public GrammarTransition getTransition(Enum<Dsmlv2StatesEnum> state, Tag tag) {
        return this.transitions[state.ordinal()].get(tag);
    }

    @Override
    public Enum<Dsmlv2StatesEnum>[] getStatesEnum() {
        return Dsmlv2StatesEnum.values();
    }

    public void setStatesEnum(Enum<Dsmlv2StatesEnum>[] statesEnum) {
        this.statesEnum = statesEnum;
    }

    @Override
    public void executeAction(Dsmlv2Container container) throws XmlPullParserException, IOException {
        XmlPullParser xpp = container.getParser();
        int eventType = xpp.getEventType();
        do {
            if (eventType == 0) {
                container.setState(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE);
                continue;
            }
            if (eventType == 1) {
                container.setState(Dsmlv2StatesEnum.GRAMMAR_END);
                continue;
            }
            if (eventType == 2) {
                this.processTag(container, 0);
                continue;
            }
            if (eventType != 3) continue;
            this.processTag(container, 1);
        } while ((eventType = xpp.next()) != 1);
    }

    private void processTag(Dsmlv2Container container, int tagType) throws XmlPullParserException {
        XmlPullParser xpp = container.getParser();
        String tagName = xpp.getName().toLowerCase();
        GrammarTransition transition = this.getTransition(container.getState(), new Tag(tagName, tagType));
        if (transition != null) {
            container.setState(transition.getNextState());
            if (transition.hasAction()) {
                GrammarAction action = transition.getAction();
                action.action(container);
            }
        } else {
            throw new XmlPullParserException(I18n.err(I18n.ERR_03036, new Tag(tagName, tagType)), xpp, null);
        }
    }
}

