/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.shared.dsmlv2.DsmlControl;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDsmlMessageDecorator<E extends Message>
implements DsmlDecorator<E>,
Message {
    private final LdapCodecService codec;
    private final E message;
    private final Map<String, Control> controls;
    private DsmlControl<? extends Control> currentControl;

    public AbstractDsmlMessageDecorator(LdapCodecService codec, E message) {
        this.codec = codec;
        this.message = message;
        this.controls = new HashMap<String, Control>();
    }

    public DsmlControl<? extends Control> getCurrentControl() {
        return this.currentControl;
    }

    public LdapCodecService getCodecService() {
        return this.codec;
    }

    @Override
    public MessageTypeEnum getType() {
        return this.message.getType();
    }

    @Override
    public Map<String, Control> getControls() {
        return this.controls;
    }

    @Override
    public Control getControl(String oid) {
        return this.controls.get(oid);
    }

    @Override
    public boolean hasControl(String oid) {
        return this.controls.containsKey(oid);
    }

    @Override
    public void addControl(Control control) throws MessageException {
        Object decorated;
        DsmlControl<CodecControl<? extends Control>> decorator;
        if (control instanceof DsmlControl) {
            decorator = (DsmlControl<CodecControl<? extends Control>>)control;
            decorated = decorator.getDecorated();
        } else {
            decorator = new DsmlControl<CodecControl<? extends Control>>(this.codec, this.codec.newControl(control));
            decorated = control;
        }
        this.message.addControl((Control)decorated);
        this.controls.put(control.getOid(), decorator);
        this.currentControl = decorator;
    }

    @Override
    public void addAllControls(Control[] controls) throws MessageException {
        for (Control control : controls) {
            this.addControl(control);
        }
    }

    @Override
    public void removeControl(Control control) throws MessageException {
        this.controls.remove(control.getOid());
        this.message.removeControl(control);
    }

    @Override
    public int getMessageId() {
        return this.message.getMessageId();
    }

    @Override
    public Object get(Object key) {
        return this.message.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.message.put(key, value);
    }

    @Override
    public void setMessageId(int messageId) {
        this.message.setMessageId(messageId);
    }

    @Override
    public E getDecorated() {
        return this.message;
    }
}

