/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.SearchScope;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkSchemaLoader
extends AbstractSchemaLoader {
    private LdapConnection connection;
    private static final String SCHEMA_BASE = "ou=schema";
    private static final String FILTER = "(objectClass=*)";
    private static final Logger LOG = LoggerFactory.getLogger(NetworkSchemaLoader.class);

    public NetworkSchemaLoader(LdapConnection connection) throws Exception {
        if (!connection.isAuthenticated()) {
            throw new IllegalArgumentException("connection is not authenticated");
        }
        this.connection = connection;
        this.initializeSchemas();
    }

    private void initializeSchemas() throws Exception {
        List<Entry> schemaEntries = this.searchSchemaObjects(SCHEMA_BASE, "(objectClass=metaSchema)");
        LOG.debug("initializing schemas {}", schemaEntries);
        for (Entry entry : schemaEntries) {
            Schema schema = this.getSchema(entry);
            this.schemaMap.put(schema.getSchemaName(), schema);
        }
    }

    private List<Entry> searchSchemaObjects(String baseDn, String filter) throws LdapException {
        try {
            LOG.debug("searching under the dn {} for schema objects", (Object)baseDn);
            ArrayList<Entry> entries = new ArrayList<Entry>();
            if (filter == null) {
                filter = FILTER;
            }
            SearchCursor cursor = this.connection.search(new Dn(baseDn), filter, SearchScope.ONELEVEL, "*", "+");
            while (cursor.next()) {
                Entry entry = ((SearchResultEntry)cursor.get()).getEntry();
                entries.add(entry);
            }
            cursor.close();
            return entries;
        }
        catch (LdapException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    private List<Entry> searchSchemaObjects(String baseDn) throws LdapException {
        return this.searchSchemaObjects(baseDn, FILTER);
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> atEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=attributeTypes,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            atEntries.addAll(entries);
        }
        return atEntries;
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> comparatorsEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=comparators,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            comparatorsEntries.addAll(entries);
        }
        return comparatorsEntries;
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditContentRulesEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=ditContentRules,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            ditContentRulesEntries.addAll(entries);
        }
        return ditContentRulesEntries;
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditStructureRulesEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=ditStructureRules,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            ditStructureRulesEntries.addAll(entries);
        }
        return ditStructureRulesEntries;
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleUsesEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=matchingRuleUse,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            matchingRuleUsesEntries.addAll(entries);
        }
        return matchingRuleUsesEntries;
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRulesEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=matchingRules,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            matchingRulesEntries.addAll(entries);
        }
        return matchingRulesEntries;
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> nameFormsEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=nameForms,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            nameFormsEntries.addAll(entries);
        }
        return nameFormsEntries;
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> normalizersEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=normalizers,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            normalizersEntries.addAll(entries);
        }
        return normalizersEntries;
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> objectClassesEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=objectClasses,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            objectClassesEntries.addAll(entries);
        }
        return objectClassesEntries;
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxCheckersEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=syntaxCheckers,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            syntaxCheckersEntries.addAll(entries);
        }
        return syntaxCheckersEntries;
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxesEntries = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> entries = this.searchSchemaObjects("ou=syntaxes,cn=" + s.getSchemaName() + "," + SCHEMA_BASE);
            syntaxesEntries.addAll(entries);
        }
        return syntaxesEntries;
    }
}

