/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.directory.ldap.client.api.ConnectionClosedEventListener;
import org.apache.directory.ldap.client.api.CramMd5Request;
import org.apache.directory.ldap.client.api.DigestMd5Request;
import org.apache.directory.ldap.client.api.GssApiRequest;
import org.apache.directory.ldap.client.api.Krb5LoginConfiguration;
import org.apache.directory.ldap.client.api.LdapAsyncConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.SaslRequest;
import org.apache.directory.ldap.client.api.SearchCursorImpl;
import org.apache.directory.ldap.client.api.callback.SaslCallbackHandler;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.ldap.client.api.future.AddFuture;
import org.apache.directory.ldap.client.api.future.BindFuture;
import org.apache.directory.ldap.client.api.future.CompareFuture;
import org.apache.directory.ldap.client.api.future.DeleteFuture;
import org.apache.directory.ldap.client.api.future.ExtendedFuture;
import org.apache.directory.ldap.client.api.future.ModifyDnFuture;
import org.apache.directory.ldap.client.api.future.ModifyFuture;
import org.apache.directory.ldap.client.api.future.ResponseFuture;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.util.OID;
import org.apache.directory.shared.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.api.LdapCodecServiceFactory;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageEncoderException;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.filter.SearchScope;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddRequestImpl;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindRequestImpl;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.apache.directory.shared.ldap.model.message.UnbindRequestImpl;
import org.apache.directory.shared.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.shared.ldap.model.message.extended.AddNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.BindNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.CompareNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.DeleteNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.ExtendedNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.ModifyDnNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.ModifyNoDResponse;
import org.apache.directory.shared.ldap.model.message.extended.SearchNoDResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.shared.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.schemaloader.JarLdifSchemaLoader;
import org.apache.directory.shared.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapNetworkConnection
extends IoHandlerAdapter
implements LdapAsyncConnection {
    private static final Logger LOG = LoggerFactory.getLogger(LdapNetworkConnection.class);
    private long timeout = 30000L;
    private LdapConnectionConfig config;
    private IoConnector connector;
    private boolean localConnector;
    private IoSession ldapSession;
    private AtomicInteger messageId;
    private Map<Integer, ResponseFuture<? extends Response>> futureMap = new ConcurrentHashMap<Integer, ResponseFuture<? extends Response>>();
    private List<String> supportedControls;
    private Entry rootDSE;
    private AtomicBoolean authenticated = new AtomicBoolean(false);
    private AtomicBoolean connected = new AtomicBoolean(false);
    private List<ConnectionClosedEventListener> conCloseListeners;
    private SchemaManager schemaManager;
    LdapCodecService codec = LdapCodecServiceFactory.getSingleton();
    private IoFilter ldapProtocolFilter = new ProtocolCodecFilter(this.codec.getProtocolCodecFactory());
    private static final String SSL_FILTER_KEY = "sslFilter";
    private static final String START_TLS_REQ_OID = "1.3.6.1.4.1.1466.20037";
    static final String TIME_OUT_ERROR = "TimeOut occured";
    static final String NO_RESPONSE_ERROR = "The response queue has been emptied, no response was found.";

    @Override
    public boolean isConnected() {
        return this.ldapSession != null && this.connected.get();
    }

    @Override
    public boolean isAuthenticated() {
        return this.isConnected() && this.authenticated.get();
    }

    private void checkSession() throws InvalidConnectionException {
        if (this.ldapSession == null) {
            throw new InvalidConnectionException("Cannot connect on the server, the connection is null");
        }
        if (!this.connected.get()) {
            throw new InvalidConnectionException("Cannot connect on the server, the connection is invalid");
        }
    }

    private void addToFutureMap(int messageId, ResponseFuture<? extends Response> future) {
        LOG.debug("Adding <" + messageId + ", " + future.getClass().getName() + ">");
        this.futureMap.put(messageId, future);
    }

    private ResponseFuture<? extends Response> getFromFutureMap(int messageId) {
        ResponseFuture<? extends Response> future = this.futureMap.remove(messageId);
        if (future != null) {
            LOG.debug("Removing <" + messageId + ", " + future.getClass().getName() + ">");
        }
        return future;
    }

    private ResponseFuture<? extends Response> peekFromFutureMap(int messageId) {
        ResponseFuture<? extends Response> future = this.futureMap.get(messageId);
        if (future != null) {
            LOG.debug("Getting <" + messageId + ", " + future.getClass().getName() + ">");
        }
        return future;
    }

    private long getTimeout(long clientTimeout) {
        if (clientTimeout <= 0L) {
            return this.timeout <= 0L ? Long.MAX_VALUE : this.timeout;
        }
        if (this.timeout <= 0L) {
            return clientTimeout;
        }
        return this.timeout < clientTimeout ? this.timeout : clientTimeout;
    }

    public LdapNetworkConnection() {
        this.config = new LdapConnectionConfig();
        this.config.setUseSsl(false);
        this.config.setLdapPort(this.config.getDefaultLdapPort());
        this.config.setLdapHost(this.config.getDefaultLdapHost());
        this.messageId = new AtomicInteger(0);
    }

    public LdapNetworkConnection(LdapConnectionConfig config) {
        this.config = config;
        this.messageId = new AtomicInteger(0);
    }

    public LdapNetworkConnection(boolean useSsl) {
        this.config = new LdapConnectionConfig();
        this.config.setUseSsl(useSsl);
        this.config.setLdapPort(useSsl ? this.config.getDefaultLdapsPort() : this.config.getDefaultLdapPort());
        this.config.setLdapHost(this.config.getDefaultLdapHost());
        this.messageId = new AtomicInteger(0);
    }

    public LdapNetworkConnection(String server) {
        this.config = new LdapConnectionConfig();
        this.config.setUseSsl(false);
        this.config.setLdapPort(this.config.getDefaultLdapPort());
        if (Strings.isEmpty(server)) {
            this.config.setLdapHost("localhost");
        } else {
            this.config.setLdapHost(server);
        }
        this.messageId = new AtomicInteger(0);
    }

    public LdapNetworkConnection(String server, boolean useSsl) {
        this.config = new LdapConnectionConfig();
        this.config.setUseSsl(useSsl);
        this.config.setLdapPort(useSsl ? this.config.getDefaultLdapsPort() : this.config.getDefaultLdapPort());
        if (Strings.isEmpty(server)) {
            this.config.setLdapHost("localhost");
        } else {
            this.config.setLdapHost(server);
        }
        this.messageId = new AtomicInteger(0);
    }

    public LdapNetworkConnection(String server, int port) {
        this(server, port, false);
    }

    public LdapNetworkConnection(String server, int port, boolean useSsl) {
        this.config = new LdapConnectionConfig();
        this.config.setUseSsl(useSsl);
        this.config.setLdapPort(port);
        if (Strings.isEmpty(server)) {
            this.config.setLdapHost("localhost");
        } else {
            this.config.setLdapHost(server);
        }
        this.messageId = new AtomicInteger();
    }

    @Override
    public boolean connect() throws LdapException, IOException {
        if (this.ldapSession != null && this.connected.get()) {
            return true;
        }
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.localConnector = true;
            this.connector.getFilterChain().addLast("ldapCodec", this.ldapProtocolFilter);
            if (this.config.isUseSsl()) {
                this.addSslFilter();
            }
            this.connector.setHandler((IoHandler)this);
        }
        InetSocketAddress address = new InetSocketAddress(this.config.getLdapHost(), this.config.getLdapPort());
        ConnectFuture connectionFuture = this.connector.connect((SocketAddress)address);
        connectionFuture.awaitUninterruptibly();
        if (!connectionFuture.isConnected()) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return false;
        }
        CloseFuture closeFuture = connectionFuture.getSession().getCloseFuture();
        closeFuture.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

            public void operationComplete(IoFuture future) {
                LOG.debug("received a NoD, closing everything");
                Iterator i$ = LdapNetworkConnection.this.futureMap.keySet().iterator();
                while (i$.hasNext()) {
                    int messageId = (Integer)i$.next();
                    ResponseFuture responseFuture = (ResponseFuture)LdapNetworkConnection.this.futureMap.get(messageId);
                    LOG.debug("closing {}", (Object)responseFuture);
                    responseFuture.cancel();
                    try {
                        if (responseFuture instanceof AddFuture) {
                            ((AddFuture)responseFuture).set(AddNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof BindFuture) {
                            ((BindFuture)responseFuture).set(BindNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof CompareFuture) {
                            ((CompareFuture)responseFuture).set(CompareNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof DeleteFuture) {
                            ((DeleteFuture)responseFuture).set(DeleteNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof ExtendedFuture) {
                            ((ExtendedFuture)responseFuture).set(ExtendedNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof ModifyFuture) {
                            ((ModifyFuture)responseFuture).set(ModifyNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof ModifyDnFuture) {
                            ((ModifyDnFuture)responseFuture).set(ModifyDnNoDResponse.PROTOCOLERROR);
                        } else if (responseFuture instanceof SearchFuture) {
                            ((SearchFuture)responseFuture).set(SearchNoDResponse.PROTOCOLERROR);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error while processing the NoD for {}", (Object)responseFuture);
                    }
                    LdapNetworkConnection.this.futureMap.remove(messageId);
                }
                LdapNetworkConnection.this.futureMap.clear();
            }
        });
        this.ldapSession = connectionFuture.getSession();
        this.connected.set(true);
        this.ldapSession.setAttribute((Object)"LDAP-Container", (Object)this.codec.newMessageContainer());
        this.messageId.set(0);
        return true;
    }

    @Override
    public boolean close() throws IOException {
        if (this.ldapSession != null && this.connected.get()) {
            this.ldapSession.close(true);
            this.connected.set(false);
        }
        if (this.localConnector && this.connector != null) {
            this.connector.dispose();
            this.connector = null;
        }
        this.messageId.set(0);
        return true;
    }

    @Override
    public AddResponse add(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = "Cannot add an empty entry";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry(entry);
        return this.add(addRequest);
    }

    @Override
    public AddFuture addAsync(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = "Cannot add null entry";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry(entry);
        return this.addAsync(addRequest);
    }

    @Override
    public AddResponse add(AddRequest addRequest) throws LdapException {
        if (addRequest == null) {
            String msg = "Cannot process a null addRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (addRequest.getEntry() == null) {
            String msg = "Cannot add a null entry";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        AddFuture addFuture = this.addAsync(addRequest);
        try {
            AddResponse addResponse = addFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (addResponse == null) {
                LOG.error("Add failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (addResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Add successful : {}", (Object)addResponse);
            } else {
                LOG.debug("Add failed : {}", (Object)addResponse);
            }
            return addResponse;
        }
        catch (TimeoutException te) {
            if (!addFuture.isCancelled()) {
                this.abandon(addRequest.getMessageId());
            }
            LOG.error("Add failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!addFuture.isCancelled()) {
                this.abandon(addRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    @Override
    public AddFuture addAsync(AddRequest addRequest) throws LdapException {
        if (addRequest == null) {
            String msg = "Cannot process a null addRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (addRequest.getEntry() == null) {
            String msg = "Cannot add a null entry";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        addRequest.setMessageId(newId);
        AddFuture addFuture = new AddFuture(this, newId);
        this.addToFutureMap(newId, addFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)addRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Add failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return addFuture;
    }

    @Override
    public void abandon(int messageId) {
        if (messageId < 0) {
            String msg = "Cannot abandon a negative message ID";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        AbandonRequestImpl abandonRequest = new AbandonRequestImpl();
        abandonRequest.setAbandoned(messageId);
        this.abandonInternal(abandonRequest);
    }

    @Override
    public void abandon(AbandonRequest abandonRequest) {
        if (abandonRequest == null) {
            String msg = "Cannot process a null abandonRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.abandonInternal(abandonRequest);
    }

    private void abandonInternal(AbandonRequest abandonRequest) {
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)abandonRequest);
        int newId = this.messageId.incrementAndGet();
        abandonRequest.setMessageId(newId);
        this.ldapSession.write((Object)abandonRequest);
        int abandonId = abandonRequest.getAbandoned();
        ResponseFuture<? extends Response> rf = this.getFromFutureMap(abandonId);
        if (rf != null) {
            LOG.debug("sending cancel signal to future");
            rf.cancel(true);
        } else {
            LOG.error("There is no future associated with operation message ID {}, perhaps the operation would have been completed", (Object)abandonId);
        }
    }

    @Override
    public BindResponse bind() throws LdapException, IOException {
        LOG.debug("Anonymous Bind request");
        BindRequest bindRequest = this.createBindRequest("", StringConstants.EMPTY_BYTES);
        return this.bind(bindRequest);
    }

    @Override
    public BindFuture bindAsync() throws LdapException, IOException {
        LOG.debug("Anonymous Bind request");
        BindRequest bindRequest = this.createBindRequest("", StringConstants.EMPTY_BYTES);
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindResponse bind(String name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = this.createBindRequest(name, Strings.getBytesUtf8(credentials));
        return this.bind(bindRequest);
    }

    @Override
    public BindFuture bindAsync(String name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = this.createBindRequest(name, Strings.getBytesUtf8(credentials));
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindResponse bind(Dn name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = this.createBindRequest(name, Strings.getBytesUtf8(credentials), null, new Control[0]);
        return this.bind(bindRequest);
    }

    @Override
    public BindFuture bindAsync(Dn name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = this.createBindRequest(name, Strings.getBytesUtf8(credentials));
        return this.bindAsync(bindRequest);
    }

    @Override
    public BindResponse bind(BindRequest bindRequest) throws LdapException, IOException {
        if (bindRequest == null) {
            String msg = "Cannot process a null bindRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(bindRequest);
        try {
            BindResponse bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                LOG.error("Bind failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                LOG.debug("Bind successful : {}", (Object)bindResponse);
            } else {
                LOG.debug("Bind failed : {}", (Object)bindResponse);
            }
            return bindResponse;
        }
        catch (TimeoutException te) {
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            throw ldapException;
        }
    }

    private BindRequest createBindRequest(String name, byte[] credentials) throws LdapException {
        return this.createBindRequest(name, credentials, null, (Control[])null);
    }

    private BindRequest createBindRequest(Dn name, byte[] credentials) throws LdapException {
        return this.createBindRequest(name, credentials, null, (Control[])null);
    }

    private BindRequest createBindRequest(String name, byte[] credentials, String saslMechanism, Control ... controls) throws LdapException {
        try {
            Dn dn = new Dn(name);
            return this.createBindRequest(dn, credentials, saslMechanism, controls);
        }
        catch (LdapInvalidDnException ine) {
            String msg = "The given dn '" + name + "' is not valid";
            LOG.error(msg);
            LdapException ldapException = new LdapException(msg);
            ldapException.initCause(ine);
            throw ldapException;
        }
    }

    private BindRequest createBindRequest(Dn name, byte[] credentials, String saslMechanism, Control ... controls) throws LdapException {
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setVersion3(true);
        bindRequest.setName(name);
        if (Strings.isEmpty(saslMechanism)) {
            bindRequest.setSimple(true);
            bindRequest.setCredentials(credentials);
        } else {
            bindRequest.setSimple(false);
            bindRequest.setCredentials(credentials);
            bindRequest.setSaslMechanism(saslMechanism);
        }
        if (controls != null && controls.length != 0) {
            bindRequest.addAllControls(controls);
        }
        return bindRequest;
    }

    @Override
    public BindFuture bindAsync(BindRequest bindRequest) throws LdapException, IOException {
        if (bindRequest == null) {
            String msg = "Cannot process a null bindRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.authenticated.set(false);
        this.connect();
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        bindRequest.setMessageId(newId);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)bindRequest);
        BindFuture bindFuture = new BindFuture(this, newId);
        this.addToFutureMap(newId, bindFuture);
        this.writeBindRequest(bindRequest);
        return bindFuture;
    }

    public BindResponse bind(CramMd5Request request) throws LdapException, IOException {
        if (request == null) {
            String msg = "Cannot process a null request";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                LOG.error("Bind failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                LOG.debug("Bind successful : {}", (Object)bindResponse);
            } else {
                LOG.debug("Bind failed : {}", (Object)bindResponse);
            }
            return bindResponse;
        }
        catch (TimeoutException te) {
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            throw ldapException;
        }
    }

    public BindFuture bindAsync(CramMd5Request request) throws LdapException, IOException {
        return this.bindSasl(request);
    }

    public BindResponse bind(DigestMd5Request request) throws LdapException, IOException {
        if (request == null) {
            String msg = "Cannot process a null request";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                LOG.error("Bind failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                LOG.debug("Bind successful : {}", (Object)bindResponse);
            } else {
                LOG.debug("Bind failed : {}", (Object)bindResponse);
            }
            return bindResponse;
        }
        catch (TimeoutException te) {
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            throw ldapException;
        }
    }

    public BindFuture bindAsync(DigestMd5Request request) throws LdapException, IOException {
        return this.bindSasl(request);
    }

    public BindResponse bind(GssApiRequest request) throws LdapException, IOException {
        if (request == null) {
            String msg = "Cannot process a null request";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        BindFuture bindFuture = this.bindAsync(request);
        try {
            BindResponse bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                LOG.error("Bind failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                LOG.debug("Bind successful : {}", (Object)bindResponse);
            } else {
                LOG.debug("Bind failed : {}", (Object)bindResponse);
            }
            return bindResponse;
        }
        catch (TimeoutException te) {
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            throw ldapException;
        }
    }

    public BindFuture bindAsync(GssApiRequest request) throws LdapException, IOException {
        System.clearProperty("java.security.krb5.conf");
        String krbConfPath = this.createKrbConfFile(request.getRealmName(), request.getKdcHost(), request.getKdcPort());
        System.setProperty("java.security.krb5.conf", krbConfPath);
        Configuration.setConfiguration(new Krb5LoginConfiguration());
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
        try {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
            LoginContext loginContext = new LoginContext("ldapnetworkconnection", new SaslCallbackHandler(request));
            loginContext.login();
            final GssApiRequest requetFinal = request;
            return (BindFuture)Subject.doAs(loginContext.getSubject(), new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return LdapNetworkConnection.this.bindSasl(requetFinal);
                }
            });
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    @Override
    public SearchCursor search(Dn baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        if (baseDn == null) {
            LOG.debug("received a null dn for a search");
            throw new IllegalArgumentException("The base Dn cannot be null");
        }
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return this.search(searchRequest);
    }

    @Override
    public SearchCursor search(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        return this.search(new Dn(baseDn), filter, scope, attributes);
    }

    @Override
    public SearchFuture searchAsync(Dn baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return this.searchAsync(searchRequest);
    }

    @Override
    public SearchFuture searchAsync(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        return this.searchAsync(new Dn(baseDn), filter, scope, attributes);
    }

    @Override
    public SearchFuture searchAsync(SearchRequest searchRequest) throws LdapException {
        if (searchRequest == null) {
            String msg = "Cannot process a null searchRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        searchRequest.setMessageId(newId);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)searchRequest);
        SearchFuture searchFuture = new SearchFuture(this, searchRequest.getMessageId());
        this.addToFutureMap(searchRequest.getMessageId(), searchFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)searchRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Search failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        if (searchFuture.isCancelled()) {
            throw new LdapException(searchFuture.getCause());
        }
        return searchFuture;
    }

    @Override
    public SearchCursor search(SearchRequest searchRequest) throws LdapException {
        if (searchRequest == null) {
            String msg = "Cannot process a null searchRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        SearchFuture searchFuture = this.searchAsync(searchRequest);
        long timeout = this.getTimeout(searchRequest.getTimeLimit());
        return new SearchCursorImpl(searchFuture, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unBind() throws LdapException {
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        UnbindRequestImpl unbindRequest = new UnbindRequestImpl(newId);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending Unbind request \n{}", (Object)unbindRequest);
        this.ldapSession.write((Object)unbindRequest);
        this.authenticated.set(false);
        this.clearMaps();
        if (this.ldapSession != null && this.connected.get()) {
            CloseFuture closeFuture = this.ldapSession.close(true);
            LOG.debug("waiting for closeFuture");
            closeFuture.awaitUninterruptibly();
            LOG.debug("closeFuture done");
            this.connected.set(false);
        }
        this.messageId.set(0);
        LOG.debug("Unbind successful");
    }

    public void setConnector(IoConnector connector) {
        this.connector = connector;
    }

    @Override
    public void setTimeOut(long timeout) {
        this.timeout = timeout <= 0L ? Long.MAX_VALUE : timeout;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LOG.warn(cause.getMessage(), cause);
        if (cause instanceof ProtocolEncoderException) {
            Throwable realCause = ((ProtocolEncoderException)cause).getCause();
            if (realCause instanceof MessageEncoderException) {
                int messageId = ((MessageEncoderException)realCause).getMessageId();
                ResponseFuture<? extends Response> response = this.futureMap.get(messageId);
                response.cancel(true);
                response.setCause(realCause);
            }
        } else {
            cause.printStackTrace();
        }
    }

    private boolean isNoticeOfDisconnect(Message message) {
        ExtendedResponse response;
        return message instanceof ExtendedResponse && (response = (ExtendedResponse)message).getResponseName().equals("1.3.6.1.4.1.1466.20036");
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        Message response = (Message)message;
        LOG.debug("-------> {} Message received <-------", (Object)response);
        int messageId = response.getMessageId();
        ResponseFuture<? extends Response> responseFuture = this.peekFromFutureMap(messageId);
        boolean isNoD = this.isNoticeOfDisconnect(response);
        if (responseFuture == null && !isNoD) {
            LOG.info("There is no future associated with the messageId {}, ignoring the message", (Object)messageId);
            return;
        }
        if (isNoD) {
            session.close(true);
            return;
        }
        switch (response.getType()) {
            case ADD_RESPONSE: {
                AddResponse addResponse = (AddResponse)response;
                AddFuture addFuture = (AddFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (addResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Add successful : {}", (Object)addResponse);
                    } else {
                        LOG.debug("Add failed : {}", (Object)addResponse);
                    }
                }
                addFuture.set(addResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case BIND_RESPONSE: {
                BindResponse bindResponse = (BindResponse)response;
                BindFuture bindFuture = (BindFuture)responseFuture;
                if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                    this.authenticated.set(true);
                    LOG.debug("Bind successful : {}", (Object)bindResponse);
                } else {
                    LOG.debug("Bind failed : {}", (Object)bindResponse);
                }
                bindFuture.set(bindResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case COMPARE_RESPONSE: {
                CompareResponse compareResponse = (CompareResponse)response;
                CompareFuture compareFuture = (CompareFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (compareResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Compare successful : {}", (Object)compareResponse);
                    } else {
                        LOG.debug("Compare failed : {}", (Object)compareResponse);
                    }
                }
                compareFuture.set(compareResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case DEL_RESPONSE: {
                DeleteResponse deleteResponse = (DeleteResponse)response;
                DeleteFuture deleteFuture = (DeleteFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (deleteResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Delete successful : {}", (Object)deleteResponse);
                    } else {
                        LOG.debug("Delete failed : {}", (Object)deleteResponse);
                    }
                }
                deleteFuture.set(deleteResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case EXTENDED_RESPONSE: {
                ExtendedResponse extendedResponse = (ExtendedResponse)response;
                ExtendedFuture extendedFuture = (ExtendedFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (extendedResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Extended successful : {}", (Object)extendedResponse);
                    } else {
                        LOG.debug("Extended failed : {}", (Object)extendedResponse);
                    }
                }
                extendedFuture.set(extendedResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case INTERMEDIATE_RESPONSE: {
                IntermediateResponseImpl intermediateResponse = null;
                if (responseFuture instanceof SearchFuture) {
                    intermediateResponse = new IntermediateResponseImpl(messageId);
                    this.addControls(intermediateResponse, response);
                    ((SearchFuture)responseFuture).set(intermediateResponse);
                } else if (responseFuture instanceof ExtendedFuture) {
                    intermediateResponse = new IntermediateResponseImpl(messageId);
                    this.addControls(intermediateResponse, response);
                    ((ExtendedFuture)responseFuture).set(intermediateResponse);
                } else {
                    throw new UnsupportedOperationException("Unknown ResponseFuture type " + responseFuture.getClass().getName());
                }
                intermediateResponse.setResponseName(((IntermediateResponse)response).getResponseName());
                intermediateResponse.setResponseValue(((IntermediateResponse)response).getResponseValue());
                break;
            }
            case MODIFY_RESPONSE: {
                ModifyResponse modifyResponse = (ModifyResponse)response;
                ModifyFuture modifyFuture = (ModifyFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (modifyResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("ModifyFuture successful : {}", (Object)modifyResponse);
                    } else {
                        LOG.debug("ModifyFuture failed : {}", (Object)modifyResponse);
                    }
                }
                modifyFuture.set(modifyResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case MODIFYDN_RESPONSE: {
                ModifyDnResponse modifyDnResponse = (ModifyDnResponse)response;
                ModifyDnFuture modifyDnFuture = (ModifyDnFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (modifyDnResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("ModifyDN successful : {}", (Object)modifyDnResponse);
                    } else {
                        LOG.debug("ModifyDN failed : {}", (Object)modifyDnResponse);
                    }
                }
                modifyDnFuture.set(modifyDnResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case SEARCH_RESULT_DONE: {
                SearchResultDone searchResultDone = (SearchResultDone)response;
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    if (searchResultDone.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Search successful : {}", (Object)searchResultDone);
                    } else {
                        LOG.debug("Search failed : {}", (Object)searchResultDone);
                    }
                }
                searchFuture.set(searchResultDone);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case SEARCH_RESULT_ENTRY: {
                SearchResultEntry searchResultEntry = (SearchResultEntry)response;
                if (this.schemaManager != null) {
                    searchResultEntry.setEntry(new DefaultEntry(this.schemaManager, searchResultEntry.getEntry()));
                }
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Search entry found : {}", (Object)searchResultEntry);
                }
                searchFuture.set(searchResultEntry);
                break;
            }
            case SEARCH_RESULT_REFERENCE: {
                SearchResultReference searchResultReference = (SearchResultReference)response;
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Search reference found : {}", (Object)searchResultReference);
                }
                searchFuture.set(searchResultReference);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected response type " + (Object)((Object)response.getType()));
            }
        }
    }

    @Override
    public ModifyResponse modify(Entry entry, ModificationOperation modOp) throws LdapException {
        if (entry == null) {
            LOG.debug("received a null entry for modification");
            throw new IllegalArgumentException("Entry to be modified cannot be null");
        }
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(entry.getDn());
        Iterator<EntryAttribute> itr = entry.iterator();
        while (itr.hasNext()) {
            modReq.addModification(itr.next(), modOp);
        }
        return this.modify(modReq);
    }

    @Override
    public ModifyResponse modify(Dn dn, Modification ... modifications) throws LdapException {
        if (dn == null) {
            LOG.debug("received a null dn for modification");
            throw new IllegalArgumentException("The Dn to be modified cannot be null");
        }
        if (modifications == null || modifications.length == 0) {
            String msg = "Cannot process a ModifyRequest without any modification";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(dn);
        for (Modification modification : modifications) {
            modReq.addModification(modification);
        }
        return this.modify(modReq);
    }

    @Override
    public ModifyResponse modify(String dn, Modification ... modifications) throws LdapException {
        return this.modify(new Dn(dn), modifications);
    }

    @Override
    public ModifyResponse modify(ModifyRequest modRequest) throws LdapException {
        if (modRequest == null) {
            String msg = "Cannot process a null modifyRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyFuture modifyFuture = this.modifyAsync(modRequest);
        try {
            ModifyResponse modifyResponse = modifyFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (modifyResponse == null) {
                LOG.error("Modify failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (modifyResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Modify successful : {}", (Object)modifyResponse);
            } else {
                if (modifyResponse instanceof ModifyNoDResponse) {
                    throw new LdapException(modifyResponse.getLdapResult().getErrorMessage());
                }
                LOG.debug("Modify failed : {}", (Object)modifyResponse);
            }
            return modifyResponse;
        }
        catch (TimeoutException te) {
            if (!modifyFuture.isCancelled()) {
                this.abandon(modRequest.getMessageId());
            }
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(ie.getMessage());
            ldapException.initCause(ie);
            if (!modifyFuture.isCancelled()) {
                this.abandon(modRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    @Override
    public ModifyFuture modifyAsync(ModifyRequest modRequest) throws LdapException {
        if (modRequest == null) {
            String msg = "Cannot process a null modifyRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        modRequest.setMessageId(newId);
        ModifyFuture modifyFuture = new ModifyFuture(this, newId);
        this.addToFutureMap(newId, modifyFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)modRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return modifyFuture;
    }

    @Override
    public ModifyDnResponse rename(String entryDn, String newRdn) throws LdapException {
        return this.rename(entryDn, newRdn, true);
    }

    @Override
    public ModifyDnResponse rename(Dn entryDn, Rdn newRdn) throws LdapException {
        return this.rename(entryDn, newRdn, true);
    }

    @Override
    public ModifyDnResponse rename(String entryDn, String newRdn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a rename of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newRdn == null) {
            String msg = "Cannot process a rename with a null Rdn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            return this.rename(new Dn(entryDn), new Rdn(newRdn), deleteOldRdn);
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    @Override
    public ModifyDnResponse rename(Dn entryDn, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a rename of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newRdn == null) {
            String msg = "Cannot process a rename with a null Rdn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyDnRequestImpl modDnRequest = new ModifyDnRequestImpl();
        modDnRequest.setName(entryDn);
        modDnRequest.setNewRdn(newRdn);
        modDnRequest.setDeleteOldRdn(deleteOldRdn);
        return this.modifyDn(modDnRequest);
    }

    @Override
    public ModifyDnResponse move(String entryDn, String newSuperiorDn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a move of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newSuperiorDn == null) {
            String msg = "Cannot process a move to a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            return this.move(new Dn(entryDn), new Dn(newSuperiorDn));
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    @Override
    public ModifyDnResponse move(Dn entryDn, Dn newSuperiorDn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a move of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newSuperiorDn == null) {
            String msg = "Cannot process a move to a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyDnRequestImpl modDnRequest = new ModifyDnRequestImpl();
        modDnRequest.setName(entryDn);
        modDnRequest.setNewSuperior(newSuperiorDn);
        modDnRequest.setNewRdn(entryDn.getRdn());
        return this.modifyDn(modDnRequest);
    }

    @Override
    public ModifyDnResponse moveAndRename(Dn entryDn, Dn newDn) throws LdapException {
        return this.moveAndRename(entryDn, newDn, true);
    }

    @Override
    public ModifyDnResponse moveAndRename(String entryDn, String newDn) throws LdapException {
        return this.moveAndRename(new Dn(entryDn), new Dn(newDn), true);
    }

    @Override
    public ModifyDnResponse moveAndRename(Dn entryDn, Dn newDn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            throw new IllegalArgumentException("The entry Dn must not be null");
        }
        if (entryDn.isRootDSE()) {
            throw new IllegalArgumentException("The RootDSE cannot be moved");
        }
        if (newDn == null) {
            throw new IllegalArgumentException("The new Dn must not be null");
        }
        if (newDn.isRootDSE()) {
            throw new IllegalArgumentException("The RootDSE cannot be the target");
        }
        ModifyDnRequestImpl modDnRequest = new ModifyDnRequestImpl();
        modDnRequest.setName(entryDn);
        modDnRequest.setNewRdn(newDn.getRdn());
        modDnRequest.setNewSuperior(newDn.getParent());
        modDnRequest.setDeleteOldRdn(deleteOldRdn);
        return this.modifyDn(modDnRequest);
    }

    @Override
    public ModifyDnResponse moveAndRename(String entryDn, String newDn, boolean deleteOldRdn) throws LdapException {
        return this.moveAndRename(new Dn(entryDn), new Dn(newDn), true);
    }

    @Override
    public ModifyDnResponse modifyDn(ModifyDnRequest modDnRequest) throws LdapException {
        if (modDnRequest == null) {
            String msg = "Cannot process a null modDnRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyDnFuture modifyDnFuture = this.modifyDnAsync(modDnRequest);
        try {
            ModifyDnResponse modifyDnResponse = modifyDnFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (modifyDnResponse == null) {
                LOG.error("ModifyDN failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (modifyDnResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("ModifyDN successful : {}", (Object)modifyDnResponse);
            } else {
                LOG.debug("Modify failed : {}", (Object)modifyDnResponse);
            }
            return modifyDnResponse;
        }
        catch (TimeoutException te) {
            if (!modifyDnFuture.isCancelled()) {
                this.abandon(modDnRequest.getMessageId());
            }
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!modifyDnFuture.isCancelled()) {
                this.abandon(modDnRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    @Override
    public ModifyDnFuture modifyDnAsync(ModifyDnRequest modDnRequest) throws LdapException {
        if (modDnRequest == null) {
            String msg = "Cannot process a null modDnRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        modDnRequest.setMessageId(newId);
        ModifyDnFuture modifyDnFuture = new ModifyDnFuture(this, newId);
        this.addToFutureMap(newId, modifyDnFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)modDnRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return modifyDnFuture;
    }

    @Override
    public DeleteResponse delete(String dn) throws LdapException {
        return this.delete(new Dn(dn));
    }

    @Override
    public DeleteResponse delete(Dn dn) throws LdapException {
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(dn);
        return this.delete(deleteRequest);
    }

    public DeleteResponse deleteTree(Dn dn) throws LdapException {
        String treeDeleteOid = "1.2.840.113556.1.4.805";
        if (this.isControlSupported(treeDeleteOid)) {
            DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
            deleteRequest.setName(dn);
            deleteRequest.addControl(new OpaqueControl(treeDeleteOid));
            return this.delete(deleteRequest);
        }
        String msg = "The subtreeDelete control (1.2.840.113556.1.4.805) is not supported by the server\n The deletion has been aborted";
        LOG.error(msg);
        throw new LdapException(msg);
    }

    public DeleteResponse deleteTree(String dn) throws LdapException {
        try {
            String treeDeleteOid = "1.2.840.113556.1.4.805";
            Dn newDn = new Dn(dn);
            if (this.isControlSupported(treeDeleteOid)) {
                DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
                deleteRequest.setName(newDn);
                deleteRequest.addControl(new OpaqueControl(treeDeleteOid));
                return this.delete(deleteRequest);
            }
            String msg = "The subtreeDelete control (1.2.840.113556.1.4.805) is not supported by the server\n The deletion has been aborted";
            LOG.error(msg);
            throw new LdapException(msg);
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    @Override
    public DeleteResponse delete(DeleteRequest deleteRequest) throws LdapException {
        if (deleteRequest == null) {
            String msg = "Cannot process a null deleteRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        DeleteFuture deleteFuture = this.deleteAsync(deleteRequest);
        try {
            DeleteResponse delResponse = deleteFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (delResponse == null) {
                LOG.error("Delete failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (delResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Delete successful : {}", (Object)delResponse);
            } else {
                LOG.debug("Delete failed : {}", (Object)delResponse);
            }
            return delResponse;
        }
        catch (TimeoutException te) {
            if (!deleteFuture.isCancelled()) {
                this.abandon(deleteRequest.getMessageId());
            }
            LOG.error("Del failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!deleteFuture.isCancelled()) {
                this.abandon(deleteRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    @Override
    public DeleteFuture deleteAsync(DeleteRequest deleteRequest) throws LdapException {
        if (deleteRequest == null) {
            String msg = "Cannot process a null deleteRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        deleteRequest.setMessageId(newId);
        DeleteFuture deleteFuture = new DeleteFuture(this, newId);
        this.addToFutureMap(newId, deleteFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)deleteRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Delete failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return deleteFuture;
    }

    @Override
    public CompareResponse compare(String dn, String attributeName, String value) throws LdapException {
        return this.compare(new Dn(dn), attributeName, value);
    }

    @Override
    public CompareResponse compare(String dn, String attributeName, byte[] value) throws LdapException {
        return this.compare(new Dn(dn), attributeName, value);
    }

    @Override
    public CompareResponse compare(String dn, String attributeName, Value<?> value) throws LdapException {
        return this.compare(new Dn(dn), attributeName, value);
    }

    @Override
    public CompareResponse compare(Dn dn, String attributeName, String value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        compareRequest.setAssertionValue(value);
        return this.compare(compareRequest);
    }

    @Override
    public CompareResponse compare(Dn dn, String attributeName, byte[] value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        compareRequest.setAssertionValue(value);
        return this.compare(compareRequest);
    }

    @Override
    public CompareResponse compare(Dn dn, String attributeName, Value<?> value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        if (value.isBinary()) {
            compareRequest.setAssertionValue(value.getBytes());
        } else {
            compareRequest.setAssertionValue(value.getString());
        }
        return this.compare(compareRequest);
    }

    @Override
    public CompareResponse compare(CompareRequest compareRequest) throws LdapException {
        if (compareRequest == null) {
            String msg = "Cannot process a null compareRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        CompareFuture compareFuture = this.compareAsync(compareRequest);
        try {
            CompareResponse compareResponse = compareFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (compareResponse == null) {
                LOG.error("Compare failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (compareResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Compare successful : {}", (Object)compareResponse);
            } else {
                LOG.debug("Compare failed : {}", (Object)compareResponse);
            }
            return compareResponse;
        }
        catch (TimeoutException te) {
            if (!compareFuture.isCancelled()) {
                this.abandon(compareRequest.getMessageId());
            }
            LOG.error("Compare failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!compareFuture.isCancelled()) {
                this.abandon(compareRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    @Override
    public CompareFuture compareAsync(CompareRequest compareRequest) throws LdapException {
        if (compareRequest == null) {
            String msg = "Cannot process a null compareRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        compareRequest.setMessageId(newId);
        CompareFuture compareFuture = new CompareFuture(this, newId);
        this.addToFutureMap(newId, compareFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)compareRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Compare failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return compareFuture;
    }

    @Override
    public ExtendedResponse extended(String oid) throws LdapException {
        return this.extended(oid, null);
    }

    @Override
    public ExtendedResponse extended(String oid, byte[] value) throws LdapException {
        try {
            return this.extended(new OID(oid), value);
        }
        catch (DecoderException e) {
            String msg = "Failed to decode the OID " + oid;
            LOG.error(msg);
            throw new LdapException(msg, e);
        }
    }

    @Override
    public ExtendedResponse extended(OID oid) throws LdapException {
        return this.extended(oid, null);
    }

    @Override
    public ExtendedResponse extended(OID oid, byte[] value) throws LdapException {
        ExtendedRequest<?> extendedRequest = LdapCodecServiceFactory.getSingleton().newExtendedRequest(oid.toString(), value);
        return this.extended(extendedRequest);
    }

    @Override
    public ExtendedResponse extended(ExtendedRequest extendedRequest) throws LdapException {
        if (extendedRequest == null) {
            String msg = "Cannot process a null extendedRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ExtendedFuture extendedFuture = this.extendedAsync(extendedRequest);
        try {
            ExtendedResponse extendedResponse = (ExtendedResponse)extendedFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (extendedResponse == null) {
                LOG.error("Extended failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (extendedResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Extended successful : {}", (Object)extendedResponse);
            } else {
                LOG.debug("Extended failed : {}", (Object)extendedResponse);
            }
            return extendedResponse;
        }
        catch (TimeoutException te) {
            if (!extendedFuture.isCancelled()) {
                this.abandon(extendedRequest.getMessageId());
            }
            LOG.error("Extended failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!extendedFuture.isCancelled()) {
                this.abandon(extendedRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    @Override
    public ExtendedFuture extendedAsync(ExtendedRequest extendedRequest) throws LdapException {
        if (extendedRequest == null) {
            String msg = "Cannot process a null extendedRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.checkSession();
        int newId = this.messageId.incrementAndGet();
        extendedRequest.setMessageId(newId);
        ExtendedFuture extendedFuture = new ExtendedFuture(this, newId);
        this.addToFutureMap(newId, extendedFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)extendedRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Extended failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return extendedFuture;
    }

    @Override
    public boolean exists(String dn) throws LdapException {
        return this.exists(new Dn(dn));
    }

    @Override
    public boolean exists(Dn dn) throws LdapException {
        try {
            Entry entry = this.lookup(dn, SchemaConstants.NO_ATTRIBUTE_ARRAY);
            return entry != null;
        }
        catch (LdapNoPermissionException lnpe) {
            return false;
        }
        catch (LdapException le) {
            throw le;
        }
    }

    @Override
    public Entry lookup(Dn dn) throws LdapException {
        return this.lookup(dn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    @Override
    public Entry lookup(String dn) throws LdapException {
        return this.lookup(dn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    @Override
    public Entry lookup(Dn dn, String ... attributes) throws LdapException {
        return this.lookup(dn, (Control[])null, attributes);
    }

    @Override
    public Entry lookup(Dn dn, Control[] controls, String ... attributes) throws LdapException {
        Entry entry = null;
        try {
            SearchCursor cursor;
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(objectClass=*)");
            searchRequest.setScope(SearchScope.OBJECT);
            searchRequest.addAttributes(attributes);
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            if (controls != null && controls.length > 0) {
                searchRequest.addAllControls(controls);
            }
            if ((cursor = this.search(searchRequest)).next()) {
                entry = ((SearchResultEntry)cursor.get()).getEntry();
            }
            cursor.next();
            cursor.close();
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
        return entry;
    }

    @Override
    public Entry lookup(String dn, String ... attributes) throws LdapException {
        return this.lookup(new Dn(dn), (Control[])null, attributes);
    }

    @Override
    public Entry lookup(String dn, Control[] controls, String ... attributes) throws LdapException {
        return this.lookup(new Dn(dn), controls, attributes);
    }

    @Override
    public boolean isControlSupported(String controlOID) throws LdapException {
        return this.getSupportedControls().contains(controlOID);
    }

    @Override
    public List<String> getSupportedControls() throws LdapException {
        if (this.supportedControls != null) {
            return this.supportedControls;
        }
        if (this.rootDSE == null) {
            this.fetchRootDSE();
        }
        this.supportedControls = new ArrayList<String>();
        EntryAttribute attr = this.rootDSE.get("supportedControl");
        for (Value value : attr) {
            this.supportedControls.add(value.getString());
        }
        return this.supportedControls;
    }

    @Override
    public void loadSchema() throws LdapException {
        try {
            JarLdifSchemaLoader jarSchemaLoader = new JarLdifSchemaLoader();
            Collection<Schema> schemas = jarSchemaLoader.getAllSchemas();
            for (Schema s : schemas) {
                s.enable();
            }
            this.loadSchema(jarSchemaLoader);
        }
        catch (LdapException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("failed to load the schema using JarLdifSchemaLoader", (Throwable)e);
            throw new LdapException(e);
        }
    }

    public void loadSchema(SchemaLoader loader) throws LdapException {
        try {
            DefaultSchemaManager tmp = new DefaultSchemaManager(loader);
            tmp.loadAllEnabled();
            if (!tmp.getErrors().isEmpty()) {
                String msg = "there are errors while loading the schema";
                LOG.error(msg + " {}", this.schemaManager.getErrors());
                throw new LdapException(msg);
            }
            this.schemaManager = tmp;
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            LOG.error("failed to load the schema", (Throwable)e);
            throw new LdapException(e);
        }
    }

    public void addSchema(File schemaFile) throws LdapException {
        try {
            if (this.schemaManager == null) {
                this.loadSchema();
            }
            OpenLdapSchemaParser olsp = new OpenLdapSchemaParser();
            olsp.setQuirksMode(true);
            olsp.parse(schemaFile);
            List<AttributeType> atList = olsp.getAttributeTypes();
            AttributeTypeRegistry atRegistry = this.schemaManager.getRegistries().getAttributeTypeRegistry();
            for (AttributeType atType : atList) {
                atRegistry.addMappingFor(atType);
            }
            List<ObjectClass> ocList = olsp.getObjectClassTypes();
            ObjectClassRegistry ocRegistry = this.schemaManager.getRegistries().getObjectClassRegistry();
            for (ObjectClass oc : ocList) {
                ocRegistry.register(oc);
            }
            LOG.info("successfully loaded the schema from file {}", (Object)schemaFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error("failed to load the schema from file {}", (Object)schemaFile.getAbsolutePath());
            throw new LdapException(e);
        }
    }

    public void addSchema(String schemaFileName) throws LdapException {
        this.addSchema(new File(schemaFileName));
    }

    @Override
    public LdapCodecService getCodecService() {
        return this.codec;
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    private void fetchRootDSE() throws LdapException {
        Cursor cursor = null;
        try {
            cursor = this.search("", "(objectClass=*)", SearchScope.OBJECT, "*", "+");
            cursor.next();
            SearchResultEntry searchRes = (SearchResultEntry)cursor.get();
            this.rootDSE = searchRes.getEntry();
        }
        catch (Exception e) {
            String msg = "Failed to fetch the RootDSE";
            LOG.error(msg);
            throw new LdapException(msg, e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close open cursor", (Throwable)e);
                }
            }
        }
    }

    @Override
    public LdapConnectionConfig getConfig() {
        return this.config;
    }

    private void addControls(Message codec, Message message) {
        Map<String, Control> controls = codec.getControls();
        if (controls != null) {
            for (Control cc : controls.values()) {
                if (cc == null) continue;
                message.addControl(cc);
            }
        }
    }

    private void removeFromFutureMaps(int msgId) {
        this.getFromFutureMap(msgId);
    }

    private void clearMaps() {
        this.futureMap.clear();
    }

    @Override
    public boolean doesFutureExistFor(int messageId) {
        ResponseFuture<? extends Response> responseFuture = this.futureMap.get(messageId);
        return responseFuture != null;
    }

    public void addConnectionClosedEventListener(ConnectionClosedEventListener ccListener) {
        if (this.conCloseListeners == null) {
            this.conCloseListeners = new ArrayList<ConnectionClosedEventListener>();
        }
        this.conCloseListeners.add(ccListener);
    }

    public void sessionCreated(IoSession session) throws Exception {
        LdapMessageContainer ldapMessageContainer = new LdapMessageContainer(this.codec, new BinaryAttributeDetector(){

            public boolean isBinary(String id) {
                try {
                    AttributeType type = LdapNetworkConnection.this.schemaManager.lookupAttributeTypeRegistry(id);
                    return !type.getSyntax().isHumanReadable();
                }
                catch (Exception e) {
                    return !Strings.isEmpty(id) && id.endsWith(";binary");
                }
            }
        });
        session.setAttribute((Object)"messageContainer", ldapMessageContainer);
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (!this.connected.get()) {
            return;
        }
        this.ldapSession.close(true);
        this.connected.set(false);
        this.messageId.set(0);
        this.localConnector = false;
        this.connector = null;
        this.clearMaps();
        if (this.conCloseListeners != null) {
            LOG.debug("notifying the registered ConnectionClosedEventListeners..");
            for (ConnectionClosedEventListener listener : this.conCloseListeners) {
                listener.connectionClosed();
            }
        }
    }

    public void startTls() throws LdapException {
        try {
            this.checkSession();
            ExtendedResponse resp = this.extended(START_TLS_REQ_OID);
            LdapResult result = resp.getLdapResult();
            if (result.getResultCode() != ResultCodeEnum.SUCCESS) {
                throw new LdapOperationException(result.getResultCode(), result.getErrorMessage());
            }
            this.addSslFilter();
        }
        catch (LdapException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
    }

    private void addSslFilter() throws LdapException {
        try {
            SSLContext sslContext = SSLContext.getInstance(this.config.getSslProtocol());
            sslContext.init(this.config.getKeyManagers(), this.config.getTrustManagers(), this.config.getSecureRandom());
            SslFilter sslFilter = new SslFilter(sslContext);
            sslFilter.setUseClientMode(true);
            if (this.ldapSession == null) {
                this.connector.getFilterChain().addFirst(SSL_FILTER_KEY, (IoFilter)sslFilter);
            } else {
                this.ldapSession.getFilterChain().addFirst(SSL_FILTER_KEY, (IoFilter)sslFilter);
            }
        }
        catch (Exception e) {
            String msg = "Failed to initialize the SSL context";
            LOG.error(msg, (Throwable)e);
            throw new LdapException(msg, e);
        }
    }

    private BindFuture bindSasl(SaslRequest saslRequest) throws LdapException, IOException {
        this.authenticated.set(false);
        this.connect();
        this.checkSession();
        BindRequest bindRequest = this.createBindRequest((String)null, null, saslRequest.getSaslMechanism(), saslRequest.getControls());
        int newId = this.messageId.incrementAndGet();
        bindRequest.setMessageId(newId);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)bindRequest);
        BindFuture bindFuture = new BindFuture(this, newId);
        this.addToFutureMap(newId, bindFuture);
        try {
            BindResponse bindResponse = null;
            byte[] response = null;
            ResultCodeEnum result = null;
            SaslClient sc = Sasl.createSaslClient(new String[]{bindRequest.getSaslMechanism()}, saslRequest.getAuthorizationId(), "ldap", this.config.getLdapHost(), null, new SaslCallbackHandler(saslRequest));
            if (sc == null) {
                String message = "Cannot find a SASL factory for the " + bindRequest.getSaslMechanism() + " mechanism";
                LOG.error(message);
                throw new LdapException(message);
            }
            if (sc.hasInitialResponse()) {
                byte[] challengeResponse = sc.evaluateChallenge(new byte[0]);
                bindRequest.setCredentials(challengeResponse);
                this.writeBindRequest(bindRequest);
                bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (bindResponse == null) {
                    LOG.error("bind failed : timeout occured");
                    throw new LdapException(TIME_OUT_ERROR);
                }
                result = bindResponse.getLdapResult().getResultCode();
            } else {
                BindRequestImpl bindRequestCopy = new BindRequestImpl(newId);
                bindRequestCopy.setName(bindRequest.getName());
                bindRequestCopy.setSaslMechanism(bindRequest.getSaslMechanism());
                bindRequestCopy.setSimple(bindRequest.isSimple());
                bindRequestCopy.setVersion3(bindRequest.getVersion3());
                bindRequestCopy.addAllControls(bindRequest.getControls().values().toArray(new Control[0]));
                this.writeBindRequest(bindRequestCopy);
                bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (bindResponse == null) {
                    LOG.error("bind failed : timeout occured");
                    throw new LdapException(TIME_OUT_ERROR);
                }
                result = bindResponse.getLdapResult().getResultCode();
            }
            while (!(sc.isComplete() || result != ResultCodeEnum.SASL_BIND_IN_PROGRESS && result != ResultCodeEnum.SUCCESS)) {
                response = sc.evaluateChallenge(bindResponse.getServerSaslCreds());
                if (result == ResultCodeEnum.SUCCESS) {
                    if (response == null) continue;
                    throw new LdapException("protocol error");
                }
                newId = this.messageId.incrementAndGet();
                bindRequest.setMessageId(newId);
                bindRequest.setCredentials(response);
                this.addToFutureMap(newId, bindFuture);
                this.writeBindRequest(bindRequest);
                bindResponse = bindFuture.get(this.timeout, TimeUnit.MILLISECONDS);
                if (bindResponse == null) {
                    LOG.error("bind failed : timeout occured");
                    throw new LdapException(TIME_OUT_ERROR);
                }
                result = bindResponse.getLdapResult().getResultCode();
            }
            bindFuture.set(bindResponse);
            return bindFuture;
        }
        catch (LdapException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LdapException(e);
        }
    }

    private void writeBindRequest(BindRequest bindRequest) throws LdapException {
        WriteFuture writeFuture = this.ldapSession.write((Object)bindRequest);
        if (!writeFuture.awaitUninterruptibly(this.timeout)) {
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
    }

    private String createKrbConfFile(String realmName, String kdcHost, int kdcPort) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("[libdefaults]").append("\n\t");
        sb.append("default_realm = ").append(realmName).append("\n");
        sb.append("[realms]").append("\n\t");
        sb.append(realmName).append(" = {").append("\n\t\t");
        sb.append("kdc = ").append(kdcHost).append(":").append(kdcPort).append("\n\t}\n");
        File krb5Conf = File.createTempFile("client-api-krb5", ".conf");
        krb5Conf.deleteOnExit();
        FileWriter fw = new FileWriter(krb5Conf);
        fw.write(sb.toString());
        fw.close();
        String krbConfPath = krb5Conf.getAbsolutePath();
        LOG.debug("krb config file created at {}", (Object)krbConfPath);
        return krbConfPath;
    }
}

