/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionConfig {
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final int DEFAULT_LDAPS_PORT = 636;
    public static final String DEFAULT_LDAP_HOST = "127.0.0.1";
    public static final int LDAP_V3 = 3;
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    private boolean useSsl = false;
    private int ldapPort;
    private String ldapHost;
    private String name;
    private String credentials;
    private KeyManager[] keyManagers;
    private SecureRandom secureRandom;
    private TrustManager[] trustManagers;
    private String sslProtocol = "TLS";
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnectionConfig.class);

    public LdapConnectionConfig() {
        this.setDefaultTrustManager();
    }

    private void setDefaultTrustManager() {
        String trustMgmtAlgo = "SunX509";
        try {
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(trustMgmtAlgo);
            tmFactory.init(KeyStore.getInstance(KeyStore.getDefaultType()));
            TrustManager[] factoryTrustManagers = tmFactory.getTrustManagers();
            for (int i = 0; i < factoryTrustManagers.length; ++i) {
                if (!(factoryTrustManagers[i] instanceof X509TrustManager)) continue;
                this.trustManagers = new TrustManager[]{factoryTrustManagers[i]};
                LOG.debug("found X509TrustManager {}", (Object)factoryTrustManagers[i]);
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("couldn't find any default X509 TrustManager with algorithm {}", (Object)trustMgmtAlgo);
        }
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public int getDefaultLdapPort() {
        return 389;
    }

    public int getDefaultLdapsPort() {
        return 636;
    }

    public String getDefaultLdapHost() {
        return DEFAULT_LDAP_HOST;
    }

    public long getDefaultTimeout() {
        return 30000L;
    }

    public int getSupportedLdapVersion() {
        return 3;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManager ... trustManagers) {
        this.trustManagers = trustManagers;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }
}

