/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.daemon;

import org.apache.directory.daemon.Bootstrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainBootstrapper
extends Bootstrapper {
    private static final Logger log = LoggerFactory.getLogger(MainBootstrapper.class);

    public static void main(String[] args) {
        log.debug("main(String[]) called");
        if (log.isDebugEnabled()) {
            log.debug("main() recieved args:");
            for (int ii = 0; ii < args.length; ++ii) {
                log.debug("args[" + ii + "] = " + args[ii]);
            }
        }
        MainBootstrapper instance = new MainBootstrapper();
        if (args.length > 1) {
            log.debug("main(String[]) initializing Bootstrapper ... )");
            instance.setInstallationLayout(args[0]);
            instance.setParentLoader(Bootstrapper.class.getClassLoader());
            log.debug("Bootstrapper initialized");
        } else {
            String msg = "Server exiting without required installation.home or command.name.";
            System.err.println(msg);
            log.error(msg);
            MainBootstrapper.printHelp();
            System.exit(1);
        }
        String command = args[args.length - 1];
        try {
            if (command.equalsIgnoreCase("start")) {
                log.debug("calling callInit(String[]) from main(String[])");
                instance.callInit(MainBootstrapper.shift(args, 2));
                log.debug("calling callStart() from main(String[])");
                instance.callStart();
                instance.waitForShutdown();
                log.debug("calling callStop() from main(String[])");
                instance.callStop(MainBootstrapper.shift(args, 2));
                log.debug("calling callDestroy() from main(String[])");
                instance.callDestroy();
            } else if (command.equalsIgnoreCase("stop")) {
                instance.sendShutdownCommand();
            } else {
                log.error("Unrecognized command " + command);
                MainBootstrapper.printHelp();
                System.exit(3);
            }
        }
        catch (Throwable t) {
            log.error("Encountered error while processing command: " + command);
            t.printStackTrace();
            System.exit(12);
        }
    }

    private static void printHelp() {
        System.err.println("java -jar bootstrap.jar <app.home> <command.name>");
    }
}

