/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.daemon;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallationLayout {
    private static final Logger log = LoggerFactory.getLogger(InstallationLayout.class);
    private static final FileFilter JAR_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".jar");
        }
    };
    public static final String VAR_DIR = "apacheds.var.dir";
    public static final String LOG_DIR = "apacheds.log.dir";
    public static final String RUN_DIR = "apacheds.run.dir";
    protected final File baseDirectory;
    private transient File[] dirs;
    private transient File[] files;
    private transient URL[] allJars = null;
    private transient URL[] dependentJars = null;
    private transient URL[] extensionJars = null;

    public InstallationLayout(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public InstallationLayout(String baseDirectoryPath) {
        this.baseDirectory = new File(baseDirectoryPath);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getBinDirectory() {
        return new File(this.baseDirectory, "bin");
    }

    public File getLibDirectory() {
        return new File(this.baseDirectory, "lib");
    }

    public File getVarDirectory() {
        String varDir = System.getProperty(VAR_DIR);
        if (varDir != null) {
            return new File(varDir);
        }
        return new File(this.baseDirectory, "var");
    }

    public File getLogDirectory() {
        String logDir = System.getProperty(LOG_DIR);
        if (logDir != null) {
            return new File(logDir);
        }
        return new File(this.getVarDirectory(), "log");
    }

    public File getRunDirectory() {
        String runDir = System.getProperty(RUN_DIR);
        if (runDir != null) {
            return new File(runDir);
        }
        return new File(this.getVarDirectory(), "run");
    }

    public File getPidFile() {
        return new File(this.getRunDirectory(), "server.pid");
    }

    public File getBootstrapper() {
        return new File(this.getLibDirectory(), "bootstrapper.jar");
    }

    public File getLogger() {
        return new File(this.getLibDirectory(), "logger.jar");
    }

    public File getDaemon() {
        return new File(this.getLibDirectory(), "wrapper.jar");
    }

    public File getInitScript() {
        return this.getInitScript("server.init");
    }

    public File getInitScript(String name) {
        return new File(this.getBinDirectory(), name);
    }

    public File getExtensionsDirectory() {
        return new File(this.getLibDirectory(), "ext");
    }

    public File getPartitionsDirectory() {
        return new File(this.getVarDirectory(), "partitions");
    }

    public File getConfigurationDirectory() {
        return new File(this.baseDirectory, "conf");
    }

    public File getConfigurationFile() {
        return this.getConfigurationFile("server.xml");
    }

    public File getConfigurationFile(String name) {
        return new File(this.getConfigurationDirectory(), name);
    }

    public File getLoggerConfigurationFile() {
        return this.getLoggerConfigurationFile("log4j.properties");
    }

    public File getLoggerConfigurationFile(String name) {
        return new File(this.getConfigurationDirectory(), name);
    }

    public File getLogoIconFile() {
        return this.getLogoIconFile("logo.ico");
    }

    public File getLogoIconFile(String name) {
        return new File(this.getBaseDirectory(), name);
    }

    public File getLicenseFile() {
        return this.getLicenseFile("LICENSE");
    }

    public File getLicenseFile(String name) {
        return new File(this.getBaseDirectory(), name);
    }

    public File getReadmeFile() {
        return this.getReadmeFile("README");
    }

    public File getReadmeFile(String name) {
        return new File(this.getBaseDirectory(), name);
    }

    public File getBootstrapperConfigurationFile() {
        return new File(this.getConfigurationDirectory(), "apacheds.conf");
    }

    public void init() {
        if (this.dirs == null) {
            this.dirs = new File[]{this.getBaseDirectory(), this.getBinDirectory(), this.getLibDirectory(), this.getExtensionsDirectory(), this.getConfigurationDirectory(), this.getVarDirectory(), this.getLogDirectory(), this.getPartitionsDirectory(), this.getRunDirectory()};
        }
        if (this.files == null) {
            this.files = new File[]{this.getBootstrapper(), this.getBootstrapperConfigurationFile()};
        }
    }

    public void verifyInstallation() {
        int ii;
        this.init();
        for (ii = 0; ii < this.dirs.length; ++ii) {
            if (!this.dirs[ii].exists()) {
                throw new IllegalStateException(this.dirs[ii] + " does not exist!");
            }
            if (this.dirs[ii].isFile()) {
                throw new IllegalStateException(this.dirs[ii] + " is a file when it should be a directory.");
            }
            if (this.dirs[ii].canWrite()) continue;
            throw new IllegalStateException(this.dirs[ii] + " is write protected from the current user: " + System.getProperty("user.name"));
        }
        for (ii = 0; ii < this.files.length; ++ii) {
            if (!this.files[ii].exists()) {
                throw new IllegalStateException(this.files[ii] + " does not exist!");
            }
            if (this.files[ii].isDirectory()) {
                throw new IllegalStateException(this.files[ii] + " is a directory when it should be a file.");
            }
            if (this.dirs[ii].canRead()) continue;
            throw new IllegalStateException(this.files[ii] + " is not readable by the current user: " + System.getProperty("user.name"));
        }
    }

    public void mkdirs() {
        this.init();
        for (int ii = 0; ii < this.dirs.length; ++ii) {
            this.dirs[ii].mkdirs();
        }
    }

    public URL[] getDependentJars() {
        if (this.dependentJars == null) {
            File[] deps = this.getLibDirectory().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            });
            this.dependentJars = new URL[deps.length];
            for (int ii = 0; ii < deps.length; ++ii) {
                try {
                    this.dependentJars[ii] = deps[ii].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    log.error("Failed to generate a URL for " + deps[ii] + ".  It will not be added to the dependencies.");
                }
            }
        }
        return this.dependentJars;
    }

    public URL[] getExtensionJars() {
        if (this.extensionJars == null) {
            File[] extensions = this.getExtensionsDirectory().listFiles(JAR_FILTER);
            this.extensionJars = new URL[extensions.length];
            for (int ii = 0; ii < extensions.length; ++ii) {
                try {
                    this.extensionJars[ii] = extensions[ii].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    log.error("Failed to generate a URL for " + extensions[ii] + ".  It will not be added to the extensions.");
                }
            }
        }
        return this.extensionJars;
    }

    public URL[] getAllJars() {
        if (this.allJars == null) {
            int dependentLength = this.getDependentJars().length;
            int extensionLength = this.getExtensionJars().length;
            this.allJars = new URL[dependentLength + extensionLength];
            for (int ii = 0; ii < this.allJars.length; ++ii) {
                this.allJars[ii] = ii < dependentLength ? this.dependentJars[ii] : this.extensionJars[ii - dependentLength];
            }
        }
        return this.allJars;
    }
}

