/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.daemon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.Random;
import org.apache.directory.daemon.AvailablePortFinder;
import org.apache.directory.daemon.DaemonApplication;
import org.apache.directory.daemon.InstallationLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrapper {
    static final String[] EMPTY_STRARRAY = new String[0];
    public static final String START_CLASS_PROP = "bootstrap.start.class";
    public static final String STOP_CLASS_PROP = "bootstrap.stop.class";
    private static final Logger log = LoggerFactory.getLogger(Bootstrapper.class);
    private static final String SHUTDOWN = "SHUTDOWN";
    private static final String SHUTDOWN_FILE = "shutdownPort";
    private int shutdownPort = -1;
    private Random random;
    private InstallationLayout layout;
    private ClassLoader application;
    private ClassLoader parent;
    private String startClassName;
    private String stopClassName;
    private Class startClass;
    private DaemonApplication start;
    private DaemonApplication stop;

    public void setInstallationLayout(String installationBase) {
        log.debug("Setting layout in Bootstrapper using base: " + installationBase);
        this.layout = new InstallationLayout(installationBase);
        try {
            this.layout.verifyInstallation();
        }
        catch (Throwable t) {
            log.error("Installation verification failure!", t);
        }
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(this.layout.getBootstrapperConfigurationFile()));
            this.startClassName = props.getProperty(START_CLASS_PROP);
            this.stopClassName = props.getProperty(STOP_CLASS_PROP);
        }
        catch (Exception e) {
            log.error("Failed while loading: " + this.layout.getBootstrapperConfigurationFile(), (Throwable)e);
            System.exit(7);
        }
    }

    public void setParentLoader(ClassLoader parentLoader) {
        this.parent = parentLoader;
        URL[] jars = this.layout.getAllJars();
        this.application = new URLClassLoader(jars, parentLoader);
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Dependencies loaded by the application ClassLoader: \n");
            for (int ii = 0; ii < jars.length; ++ii) {
                buf.append("\t").append(jars[ii]).append("\n");
            }
            log.debug(buf.toString());
        }
    }

    public void callInit(String[] args) {
        Thread.currentThread().setContextClassLoader(this.application);
        try {
            this.startClass = this.application.loadClass(args[0]);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find " + this.startClassName, (Throwable)e);
            System.exit(1);
        }
        try {
            this.start = (DaemonApplication)this.startClass.newInstance();
        }
        catch (Exception e) {
            log.error("Could not instantiate " + this.startClassName, (Throwable)e);
            System.exit(2);
        }
        try {
            this.start.init(this.layout, Bootstrapper.shift(args, 1));
        }
        catch (Exception e) {
            log.error("Failed on " + this.startClassName + ".init(InstallationLayout, String[])", (Throwable)e);
            System.exit(4);
        }
        Thread.currentThread().setContextClassLoader(this.parent);
    }

    public void callStart() {
        Thread.currentThread().setContextClassLoader(this.application);
        try {
            this.start.start();
        }
        catch (Exception e) {
            log.error("Failed on " + this.startClass.getName() + ".start()", (Throwable)e);
            System.exit(5);
        }
        Thread.currentThread().setContextClassLoader(this.parent);
    }

    public void callStop(String[] args) {
        Thread.currentThread().setContextClassLoader(this.application);
        this.stop = this.start;
        try {
            this.stop.stop(args);
        }
        catch (Exception e) {
            log.error("Failed on " + this.stopClassName + ".stop()", (Throwable)e);
            System.exit(6);
        }
        Thread.currentThread().setContextClassLoader(this.parent);
    }

    public void callDestroy() {
        Thread.currentThread().setContextClassLoader(this.application);
        try {
            this.stop.destroy();
        }
        catch (Exception e) {
            log.error("Failed on " + this.stopClassName + ".destroy()", (Throwable)e);
            System.exit(6);
        }
        Thread.currentThread().setContextClassLoader(this.parent);
    }

    public static String[] shift(String[] args, int amount) {
        if (args.length > amount) {
            String[] shifted = new String[args.length - 1];
            System.arraycopy(args, 1, shifted, 0, shifted.length);
            return shifted;
        }
        return EMPTY_STRARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendShutdownCommand() throws IOException {
        Socket socket = null;
        OutputStream stream = null;
        if (this.shutdownPort == -1) {
            File shutdownPortFile = new File(this.layout.getRunDirectory(), SHUTDOWN_FILE);
            if (shutdownPortFile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(shutdownPortFile));
                this.shutdownPort = Integer.parseInt(in.readLine());
                in.close();
            } else {
                String msg = "The server does not seem to be running!  The shutdown port file\n";
                msg = msg + shutdownPortFile + " does not exist!";
                log.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        try {
            socket = new Socket("127.0.0.1", this.shutdownPort);
            stream = socket.getOutputStream();
            for (int i = 0; i < SHUTDOWN.length(); ++i) {
                stream.write(SHUTDOWN.charAt(i));
            }
            stream.flush();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    public void waitForShutdown() {
        try {
            this.shutdownPort = AvailablePortFinder.getNextAvailable(30003);
            File shutdownPortFile = new File(this.layout.getRunDirectory(), SHUTDOWN_FILE);
            if (shutdownPortFile.exists()) {
                String msg = "Shutdown port file " + shutdownPortFile + " exists. ";
                msg = msg + "\nEither an instance is already running or a previous run existed abruptly.";
                log.warn(msg);
                shutdownPortFile.delete();
            }
            PrintWriter out = new PrintWriter(new FileWriter(shutdownPortFile));
            out.println(this.shutdownPort);
            out.flush();
            out.close();
            Runtime.getRuntime().addShutdownHook(new Thread("Bootstrapper cleanup"){

                public void run() {
                    File shutdownPortFile = new File(Bootstrapper.this.layout.getRunDirectory(), Bootstrapper.SHUTDOWN_FILE);
                    if (shutdownPortFile.exists()) {
                        shutdownPortFile.delete();
                        log.info("Deleted shutdown port file: " + Bootstrapper.this.shutdownPort);
                    }
                }
            });
        }
        catch (IOException e) {
            log.error("Failed to setup shutdown port", (Throwable)e);
            System.exit(5);
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.shutdownPort, 1, InetAddress.getByName("127.0.0.1"));
            log.debug("waiting for shutdown command on port = " + this.shutdownPort);
        }
        catch (IOException e) {
            log.error("server waitForShutdown: create[" + this.shutdownPort + "]: ", (Throwable)e);
            System.exit(1);
        }
        while (true) {
            int expected;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                log.warn("Standard Server.accept security exception: " + ace.getMessage(), (Throwable)ace);
                continue;
            }
            catch (IOException e) {
                log.error("Server.await: accept: ", (Throwable)e);
                System.exit(5);
            }
            StringBuffer command = new StringBuffer();
            for (expected = 1024; expected < SHUTDOWN.length(); expected += this.random.nextInt() % 1024) {
                if (this.random != null) continue;
                this.random = new Random(System.currentTimeMillis());
            }
            while (expected > 0) {
                int ch;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    log.warn("StandardServer.await: read: ", (Throwable)e);
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                log.debug("Failed on socket close", (Throwable)e);
            }
            boolean match = command.toString().equals(SHUTDOWN);
            if (match) break;
            log.warn("Server.await: Invalid command '" + command.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException e) {
            log.debug("Failed on socket close", (Throwable)e);
        }
        File shutdownPortFile = new File(this.layout.getRunDirectory(), SHUTDOWN_FILE);
        if (shutdownPortFile.exists()) {
            shutdownPortFile.delete();
        }
    }
}

