/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectClassTypeSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectClassTypeSyntaxChecker.class);

    public ObjectClassTypeSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.0.0.1");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() < 8 || strValue.length() > 10) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        char ch = strValue.charAt(0);
        switch (ch) {
            case 'A': {
                if ("AUXILIARY".equals(strValue) || "ABSTRACT".equals(strValue)) {
                    LOG.debug("Syntax valid for '{}'", value);
                    return true;
                }
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            case 'S': {
                boolean result = "STRUCTURAL".equals(strValue);
                if (result) {
                    LOG.debug("Syntax valid for '{}'", value);
                } else {
                    LOG.debug("Syntax invalid for '{}'", value);
                }
                return result;
            }
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }
}

