/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.parsers.NameFormDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameFormDescriptionSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(NameFormDescriptionSyntaxChecker.class);
    private NameFormDescriptionSchemaParser schemaParser = new NameFormDescriptionSchemaParser();

    public NameFormDescriptionSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.35");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        try {
            this.schemaParser.parseNameFormDescription(strValue);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

