/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SearchScope {
    OBJECT(0, "base"),
    ONELEVEL(1, "one"),
    SUBTREE(2, "sub");

    private final int scope;
    private final String ldapUrlValue;

    private SearchScope(int scope, String ldapUrlValue) {
        this.scope = scope;
        this.ldapUrlValue = ldapUrlValue;
    }

    public String getLdapUrlValue() {
        return this.ldapUrlValue;
    }

    public int getScope() {
        return this.scope;
    }

    public static SearchScope getSearchScope(int scope) {
        switch (scope) {
            case 0: {
                return OBJECT;
            }
            case 1: {
                return ONELEVEL;
            }
            case 2: {
                return SUBTREE;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04160, (Object[])new Object[]{scope}));
    }

    public static int getSearchScope(String ldapUrlValue) {
        if ("base".equalsIgnoreCase(ldapUrlValue)) {
            return OBJECT.getScope();
        }
        if ("one".equalsIgnoreCase(ldapUrlValue)) {
            return ONELEVEL.getScope();
        }
        if ("sub".equalsIgnoreCase(ldapUrlValue)) {
            return SUBTREE.getScope();
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04161, (Object[])new Object[]{ldapUrlValue}));
    }

    public String toString() {
        return this.ldapUrlValue;
    }
}

