/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifControl;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifEntry
implements Cloneable,
Externalizable {
    public static final Modification[] EMPTY_MODS = new Modification[0];
    private ChangeType changeType;
    private List<Modification> modificationList;
    private Map<String, Modification> modifications;
    private String newSuperior;
    private String newRdn;
    private boolean deleteOldRdn;
    private Entry entry;
    private Dn entryDn;
    private Map<String, LdifControl> controls;

    public LdifEntry() {
        this.changeType = ChangeType.None;
        this.modificationList = new LinkedList<Modification>();
        this.modifications = new HashMap<String, Modification>();
        this.entry = new DefaultEntry((Dn)null);
        this.entryDn = null;
        this.controls = null;
    }

    public LdifEntry(Entry entry) {
        this.changeType = ChangeType.None;
        this.modificationList = new LinkedList<Modification>();
        this.modifications = new HashMap<String, Modification>();
        this.entry = entry;
        this.entryDn = entry.getDn();
        this.controls = null;
    }

    public LdifEntry(Dn dn, Object ... avas) throws LdapInvalidAttributeValueException, LdapLdifException {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        boolean valueExpected = false;
        String dnStr = null;
        dnStr = dn == null ? "" : dn.getName();
        if (LdifUtils.isLDIFSafe(dnStr)) {
            sb.append("dn: ").append(dnStr).append('\n');
        } else {
            sb.append("dn:: ").append(Base64.encode((byte[])Strings.getBytesUtf8((String)dnStr))).append('\n');
        }
        for (Object ava : avas) {
            if (!valueExpected) {
                if (!(ava instanceof String)) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((I18n)I18n.ERR_12085, (Object[])new Object[]{pos + 1}));
                }
                String attribute = (String)ava;
                sb.append(attribute);
                if (attribute.indexOf(58) != -1) {
                    sb.append('\n');
                    continue;
                }
                valueExpected = true;
                continue;
            }
            if (ava instanceof String) {
                sb.append(": ").append((String)ava).append('\n');
            } else if (ava instanceof byte[]) {
                sb.append(":: ");
                sb.append(new String(Base64.encode((byte[])((byte[])ava))));
                sb.append('\n');
            } else {
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((I18n)I18n.ERR_12086, (Object[])new Object[]{pos + 1}));
            }
            valueExpected = false;
        }
        if (valueExpected) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((I18n)I18n.ERR_12087, (Object[])new Object[0]));
        }
        LdifReader reader = new LdifReader();
        List<LdifEntry> ldifEntries = reader.parseLdif(sb.toString());
        if (ldifEntries != null && ldifEntries.size() == 1) {
            LdifEntry ldifEntry = ldifEntries.get(0);
            this.changeType = ldifEntry.getChangeType();
            this.controls = ldifEntry.getControls();
            this.entryDn = ldifEntry.getDn();
            switch (ldifEntry.getChangeType()) {
                case Add: 
                case None: {
                    this.entry = ldifEntry.getEntry();
                    break;
                }
                case Delete: {
                    break;
                }
                case ModDn: 
                case ModRdn: {
                    this.newRdn = ldifEntry.getNewRdn();
                    this.newSuperior = ldifEntry.getNewSuperior();
                    this.deleteOldRdn = ldifEntry.isDeleteOldRdn();
                    break;
                }
                case Modify: {
                    this.modificationList = ldifEntry.getModifications();
                    this.modifications = new HashMap<String, Modification>();
                    for (Modification modification : this.modificationList) {
                        this.modifications.put(modification.getAttribute().getId(), modification);
                    }
                    break;
                }
            }
        }
    }

    public LdifEntry(String dn, Object ... strings) throws LdapInvalidAttributeValueException, LdapLdifException, LdapInvalidDnException {
        this(new Dn(dn), strings);
    }

    public void setDn(Dn dn) {
        this.entryDn = dn;
        this.entry.setDn(dn);
    }

    public void setDn(String dn) throws LdapInvalidDnException {
        this.entryDn = new Dn(dn);
        this.entry.setDn(this.entryDn);
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setChangeType(String changeType) {
        if ("add".equals(changeType)) {
            this.changeType = ChangeType.Add;
        } else if ("modify".equals(changeType)) {
            this.changeType = ChangeType.Modify;
        } else if ("moddn".equals(changeType)) {
            this.changeType = ChangeType.ModDn;
        } else if ("modrdn".equals(changeType)) {
            this.changeType = ChangeType.ModRdn;
        } else if ("delete".equals(changeType)) {
            this.changeType = ChangeType.Delete;
        }
    }

    public void addModification(Modification modification) {
        if (this.changeType == ChangeType.Modify) {
            this.modificationList.add(modification);
            this.modifications.put(modification.getAttribute().getId(), modification);
        }
    }

    public void addModification(ModificationOperation modOp, Attribute attr) {
        if (this.changeType == ChangeType.Modify) {
            DefaultModification item = new DefaultModification(modOp, attr);
            this.modificationList.add(item);
            this.modifications.put(attr.getId(), item);
        }
    }

    public void addModification(ModificationOperation modOp, String id, Object value) {
        if (this.changeType == ChangeType.Modify) {
            Attribute attr;
            if (value == null) {
                value = new StringValue((String)null);
                attr = new DefaultAttribute(id, (Value)value);
            } else {
                attr = (Attribute)value;
            }
            DefaultModification item = new DefaultModification(modOp, attr);
            this.modificationList.add(item);
            this.modifications.put(id, item);
        }
    }

    public void addAttribute(Attribute attr) throws LdapException {
        this.entry.put(attr);
    }

    public void addAttribute(String id, Object ... values) throws LdapException {
        if (values != null) {
            for (Object value : values) {
                if (value instanceof String) {
                    this.entry.add(id, (String)value);
                    continue;
                }
                this.entry.add(id, (byte[][])new byte[][]{(byte[])value});
            }
        } else {
            this.entry.add(id, new Value[]{null});
        }
    }

    public void removeAttribute(String ... ids) {
        if (this.entry.containsAttribute(ids)) {
            this.entry.removeAttributes(ids);
        }
    }

    public void putAttribute(String id, Object value) throws LdapException {
        if (value instanceof String) {
            this.entry.add(id, (String)value);
        } else {
            this.entry.add(id, (byte[][])new byte[][]{(byte[])value});
        }
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<Modification> getModifications() {
        return this.modificationList;
    }

    public Modification[] getModificationArray() {
        return this.modificationList.toArray(EMPTY_MODS);
    }

    public Dn getDn() {
        return this.entryDn;
    }

    public int size() {
        return this.modificationList.size();
    }

    public Attribute get(String attributeId) {
        if ("dn".equalsIgnoreCase(attributeId)) {
            return new DefaultAttribute("dn", this.entry.getDn().getName());
        }
        return this.entry.get(attributeId);
    }

    public Entry getEntry() {
        if (this.isEntry()) {
            return this.entry;
        }
        return null;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public boolean isLdifContent() {
        return this.changeType == ChangeType.None;
    }

    public boolean isLdifChange() {
        return this.changeType != ChangeType.None;
    }

    public boolean isChangeAdd() {
        return this.changeType == ChangeType.Add;
    }

    public boolean isChangeDelete() {
        return this.changeType == ChangeType.Delete;
    }

    public boolean isChangeModDn() {
        return this.changeType == ChangeType.ModDn;
    }

    public boolean isChangeModRdn() {
        return this.changeType == ChangeType.ModRdn;
    }

    public boolean isChangeModify() {
        return this.changeType == ChangeType.Modify;
    }

    public boolean isEntry() {
        return this.changeType == ChangeType.None || this.changeType == ChangeType.Add;
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public Map<String, LdifControl> getControls() {
        return this.controls;
    }

    public LdifControl getControl(String oid) {
        if (this.controls != null) {
            return this.controls.get(oid);
        }
        return null;
    }

    public void addControl(Control ... controls) {
        if (controls == null) {
            throw new IllegalArgumentException("The added control must not be null");
        }
        for (Control control : controls) {
            if (this.changeType == ChangeType.None) {
                this.changeType = ChangeType.Add;
            }
            if (this.controls == null) {
                this.controls = new ConcurrentHashMap<String, LdifControl>();
            }
            if (control instanceof LdifControl) {
                this.controls.put(control.getOid(), (LdifControl)control);
                continue;
            }
            LdifControl ldifControl = new LdifControl(control.getOid());
            ldifControl.setCritical(control.isCritical());
            this.controls.put(control.getOid(), new LdifControl(control.getOid()));
        }
    }

    public LdifEntry clone() throws CloneNotSupportedException {
        LdifEntry clone = (LdifEntry)super.clone();
        if (this.modificationList != null) {
            for (Modification modif : this.modificationList) {
                DefaultModification modifClone = new DefaultModification(modif.getOperation(), modif.getAttribute().clone());
                clone.modificationList.add(modifClone);
            }
        }
        if (this.modifications != null) {
            for (String key : this.modifications.keySet()) {
                Modification modif = this.modifications.get(key);
                DefaultModification modifClone = new DefaultModification(modif.getOperation(), modif.getAttribute().clone());
                clone.modifications.put(key, modifClone);
            }
        }
        if (this.entry != null) {
            clone.entry = this.entry.clone();
        }
        return clone;
    }

    public String toString() {
        try {
            return LdifUtils.convertToLdif(this);
        }
        catch (LdapException ne) {
            return "";
        }
    }

    public int hashCode() {
        int result = 37;
        if (this.entry != null && this.entry.getDn() != null) {
            result = result * 17 + this.entry.getDn().hashCode();
        }
        if (this.changeType != null) {
            result = result * 17 + this.changeType.hashCode();
            switch (this.changeType) {
                case Add: {
                    if (this.entry == null) break;
                    result = result * 17 + this.entry.hashCode();
                    break;
                }
                case Delete: {
                    break;
                }
                case Modify: {
                    if (this.modificationList == null) break;
                    result = result * 17 + this.modificationList.hashCode();
                    for (Modification modification : this.modificationList) {
                        result = result * 17 + modification.hashCode();
                    }
                    break;
                }
                case ModDn: 
                case ModRdn: {
                    result *= 17;
                    result = this.deleteOldRdn ? ++result : --result;
                    if (this.newRdn != null) {
                        result = result * 17 + this.newRdn.hashCode();
                    }
                    if (this.newSuperior == null) break;
                    result = result * 17 + this.newSuperior.hashCode();
                    break;
                }
            }
        }
        if (this.controls != null) {
            for (String control : this.controls.keySet()) {
                result = result * 17 + control.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LdifEntry)) {
            return false;
        }
        Dn thisDn = this.entryDn;
        LdifEntry otherEntry = (LdifEntry)o;
        Dn dnEntry = otherEntry.getDn();
        if (!thisDn.equals(dnEntry)) {
            return false;
        }
        if (this.changeType != otherEntry.changeType) {
            return false;
        }
        switch (this.changeType) {
            case Add: {
                if (this.entry.size() != otherEntry.entry.size()) {
                    return false;
                }
                if (this.entry.equals(otherEntry.entry)) break;
                return false;
            }
            case Delete: {
                break;
            }
            case Modify: {
                if (this.modificationList == null) {
                    if (otherEntry.modificationList == null) break;
                    return false;
                }
                if (otherEntry.modificationList == null) {
                    return false;
                }
                if (this.modificationList.size() != otherEntry.modificationList.size()) {
                    return false;
                }
                int i = 0;
                for (Modification modification : this.modificationList) {
                    if (!modification.equals(otherEntry.modificationList.get(i))) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (this.deleteOldRdn != otherEntry.deleteOldRdn) {
                    return false;
                }
                try {
                    Rdn thisNewRdn = new Rdn(this.newRdn);
                    Rdn entryNewRdn = new Rdn(otherEntry.newRdn);
                    if (!thisNewRdn.equals(entryNewRdn)) {
                        return false;
                    }
                }
                catch (LdapInvalidDnException ine) {
                    return false;
                }
                try {
                    Dn thisNewSuperior = new Dn(this.newSuperior);
                    Dn entryNewSuperior = new Dn(otherEntry.newSuperior);
                    if (!thisNewSuperior.equals(entryNewSuperior)) {
                        return false;
                    }
                    break;
                }
                catch (LdapInvalidDnException ine) {
                    return false;
                }
            }
        }
        if (this.controls != null) {
            Map<String, LdifControl> otherControls = otherEntry.controls;
            if (otherControls == null) {
                return false;
            }
            if (this.controls.size() != otherControls.size()) {
                return false;
            }
            for (String controlOid : this.controls.keySet()) {
                if (!otherControls.containsKey(controlOid)) {
                    return false;
                }
                Control thisControl = this.controls.get(controlOid);
                Control otherControl = otherControls.get(controlOid);
                if (!(thisControl == null ? otherControl != null : !thisControl.equals(otherControl))) continue;
                return false;
            }
            return true;
        }
        return otherEntry.controls == null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int type = in.readInt();
        this.changeType = ChangeType.getChangeType(type);
        switch (this.changeType) {
            case Add: 
            case None: {
                this.entry.readExternal(in);
                this.entryDn = this.entry.getDn();
                break;
            }
            case Delete: {
                this.entryDn = new Dn();
                this.entryDn.readExternal(in);
                break;
            }
            case ModDn: 
            case ModRdn: {
                this.entryDn = new Dn();
                this.entryDn.readExternal(in);
                this.deleteOldRdn = in.readBoolean();
                if (in.readBoolean()) {
                    this.newRdn = in.readUTF();
                }
                if (!in.readBoolean()) break;
                this.newSuperior = in.readUTF();
                break;
            }
            case Modify: {
                this.entryDn = new Dn();
                this.entryDn.readExternal(in);
                int nbModifs = in.readInt();
                for (i = 0; i < nbModifs; ++i) {
                    DefaultModification modification = new DefaultModification();
                    modification.readExternal(in);
                    this.addModification(modification);
                }
                break;
            }
        }
        int nbControls = in.readInt();
        if (nbControls > 0) {
            this.controls = new ConcurrentHashMap<String, LdifControl>(nbControls);
            for (i = 0; i < nbControls; ++i) {
                LdifControl control = new LdifControl();
                control.readExternal(in);
                this.controls.put(control.getOid(), control);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.changeType.getChangeType());
        switch (this.changeType) {
            case Add: 
            case None: {
                this.entry.writeExternal(out);
                break;
            }
            case Delete: {
                this.entryDn.writeExternal(out);
                break;
            }
            case ModDn: 
            case ModRdn: {
                this.entryDn.writeExternal(out);
                out.writeBoolean(this.deleteOldRdn);
                if (this.newRdn == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.newRdn);
                }
                if (this.newSuperior != null) {
                    out.writeBoolean(true);
                    out.writeUTF(this.newSuperior);
                    break;
                }
                out.writeBoolean(false);
                break;
            }
            case Modify: {
                this.entryDn.writeExternal(out);
                out.writeInt(this.modificationList.size());
                for (Modification modification : this.modificationList) {
                    modification.writeExternal(out);
                }
                break;
            }
        }
        if (this.controls != null) {
            out.writeInt(this.controls.size());
            for (LdifControl control : this.controls.values()) {
                control.writeExternal(out);
            }
        } else {
            out.writeInt(-1);
        }
        out.flush();
    }
}

