/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModification
implements Modification {
    private ModificationOperation operation;
    private Attribute attribute;
    private AttributeType attributeType;
    protected static final Logger LOG = LoggerFactory.getLogger(Modification.class);

    public DefaultModification() {
    }

    public DefaultModification(ModificationOperation operation, Attribute attribute) {
        this.operation = operation;
        this.attribute = attribute;
    }

    public DefaultModification(ModificationOperation operation, String attributeId, String ... values) {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeId, values);
    }

    public DefaultModification(ModificationOperation operation, String attributeId, byte[] ... values) {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeId, values);
    }

    public DefaultModification(ModificationOperation operation, String attributeId, Value<?> ... values) {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeId, values);
    }

    public DefaultModification(ModificationOperation operation, String attributeId) {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeId);
    }

    public DefaultModification(ModificationOperation operation, AttributeType attributeType, String ... values) throws LdapInvalidAttributeValueException {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeType, values);
    }

    public DefaultModification(ModificationOperation operation, AttributeType attributeType, byte[] ... values) throws LdapInvalidAttributeValueException {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeType, values);
    }

    public DefaultModification(ModificationOperation operation, AttributeType attributeType, Value<?> ... values) throws LdapInvalidAttributeValueException {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeType, values);
    }

    public DefaultModification(ModificationOperation operation, AttributeType attributeType) throws LdapInvalidAttributeValueException {
        this.operation = operation;
        this.attribute = new DefaultAttribute(attributeType);
    }

    public DefaultModification(SchemaManager schemaManager, Modification modification) {
        this.operation = modification.getOperation();
        Attribute modAttribute = modification.getAttribute();
        try {
            AttributeType at = modAttribute.getAttributeType();
            if (at == null) {
                at = schemaManager.lookupAttributeTypeRegistry(modAttribute.getId());
            }
            this.attribute = new DefaultAttribute(at, modAttribute);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err((I18n)I18n.ERR_04472, (Object[])new Object[]{modAttribute.getId()}));
        }
    }

    @Override
    public ModificationOperation getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(int operation) {
        this.operation = ModificationOperation.getOperation(operation);
    }

    @Override
    public void setOperation(ModificationOperation operation) {
        this.operation = operation;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public void apply(AttributeType attributeType) throws LdapInvalidAttributeValueException {
        this.attributeType = attributeType;
        if (this.attribute != null) {
            this.attribute.apply(attributeType);
        }
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Modification)) {
            return false;
        }
        Modification otherModification = (Modification)that;
        if (this.operation != otherModification.getOperation()) {
            return false;
        }
        if (this.attribute == null) {
            return otherModification.getAttribute() == null;
        }
        return this.attribute.equals(otherModification.getAttribute());
    }

    public int hashCode() {
        int h = 37;
        h += h * 17 + this.operation.getValue();
        h += h * 17 + this.attribute.hashCode();
        return h;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = ModificationOperation.getOperation(in.readInt());
        boolean hasAttribute = in.readBoolean();
        if (hasAttribute) {
            this.attribute = new DefaultAttribute();
            this.attribute.readExternal(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.operation.getValue());
        if (this.attribute != null) {
            out.writeBoolean(true);
            this.attribute.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.flush();
    }

    @Override
    public DefaultModification clone() {
        try {
            DefaultModification clone = (DefaultModification)super.clone();
            clone.attribute = this.attribute.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Modification: ").append((Object)this.operation).append("\n").append(", attribute : ").append(this.attribute);
        return sb.toString();
    }
}

