/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownDecoder;
import org.apache.directory.api.ldap.extras.extended.gracefulShutdown.GracefulShutdownRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownRequestDecorator
extends ExtendedRequestDecorator<GracefulShutdownRequest>
implements GracefulShutdownRequest {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownRequestDecorator.class);
    private int gracefulSequenceLength;
    private GracefulShutdownRequest gracefulShutdownRequest;

    public GracefulShutdownRequestDecorator(LdapApiService codec, GracefulShutdownRequest decoratedMessage) {
        super(codec, decoratedMessage);
        this.gracefulShutdownRequest = decoratedMessage;
    }

    @Override
    public void setRequestValue(byte[] requestValue) {
        GracefulShutdownDecoder decoder = new GracefulShutdownDecoder();
        try {
            this.gracefulShutdownRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04165, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_04164, new Object[0]), e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    @Override
    public int getDelay() {
        return ((GracefulShutdownRequest)this.getDecorated()).getDelay();
    }

    @Override
    public void setDelay(int delay) {
        ((GracefulShutdownRequest)this.getDecorated()).setDelay(delay);
    }

    @Override
    public int getTimeOffline() {
        return ((GracefulShutdownRequest)this.getDecorated()).getTimeOffline();
    }

    @Override
    public void setTimeOffline(int timeOffline) {
        ((GracefulShutdownRequest)this.getDecorated()).setTimeOffline(timeOffline);
    }

    int computeLengthInternal() {
        int gracefulLength = 2;
        this.gracefulSequenceLength = 0;
        if (this.gracefulShutdownRequest.getTimeOffline() != 0) {
            this.gracefulSequenceLength += 2 + BerValue.getNbBytes(this.gracefulShutdownRequest.getTimeOffline());
        }
        if (this.gracefulShutdownRequest.getDelay() != 0) {
            this.gracefulSequenceLength += 2 + BerValue.getNbBytes(this.gracefulShutdownRequest.getDelay());
        }
        return gracefulLength + this.gracefulSequenceLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.gracefulSequenceLength));
        if (this.gracefulShutdownRequest.getTimeOffline() != 0) {
            BerValue.encode(bb, this.gracefulShutdownRequest.getTimeOffline());
        }
        if (this.gracefulShutdownRequest.getDelay() != 0) {
            bb.put((byte)-128);
            bb.put((byte)BerValue.getNbBytes(this.gracefulShutdownRequest.getDelay()));
            bb.put(BerValue.getBytes(this.gracefulShutdownRequest.getDelay()));
        }
        return bb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Graceful Shutdown extended operation");
        sb.append("    TimeOffline : ").append(this.gracefulShutdownRequest.getTimeOffline()).append('\n');
        sb.append("    Delay : ").append(this.gracefulShutdownRequest.getDelay()).append('\n');
        return sb.toString();
    }
}

