/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateResponseDecorator
extends MessageDecorator<IntermediateResponse>
implements IntermediateResponse {
    private byte[] responseNameBytes;
    private int intermediateResponseLength;

    public IntermediateResponseDecorator(LdapApiService codec, IntermediateResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setIntermediateResponseLength(int intermediateResponseLength) {
        this.intermediateResponseLength = intermediateResponseLength;
    }

    public int getIntermediateResponseLength() {
        return this.intermediateResponseLength;
    }

    public byte[] getResponseNameBytes() {
        return this.responseNameBytes;
    }

    public void setResponseNameBytes(byte[] responseNameBytes) {
        this.responseNameBytes = responseNameBytes;
    }

    @Override
    public String getResponseName() {
        return ((IntermediateResponse)this.getDecorated()).getResponseName();
    }

    @Override
    public void setResponseName(String oid) {
        ((IntermediateResponse)this.getDecorated()).setResponseName(oid);
    }

    @Override
    public byte[] getResponseValue() {
        return ((IntermediateResponse)this.getDecorated()).getResponseValue();
    }

    @Override
    public void setResponseValue(byte[] value) {
        ((IntermediateResponse)this.getDecorated()).setResponseValue(value);
    }

    @Override
    public int computeLength() {
        byte[] encodedValue;
        int intermediateResponseLength = 0;
        if (!Strings.isEmpty(this.getResponseName())) {
            byte[] responseNameBytes = Strings.getBytesUtf8(this.getResponseName());
            int responseNameLength = responseNameBytes.length;
            intermediateResponseLength += 1 + TLV.getNbBytes(responseNameLength) + responseNameLength;
            this.setResponseNameBytes(responseNameBytes);
        }
        if ((encodedValue = this.getResponseValue()) != null) {
            intermediateResponseLength += 1 + TLV.getNbBytes(encodedValue.length) + encodedValue.length;
        }
        this.setIntermediateResponseLength(intermediateResponseLength);
        return 1 + TLV.getNbBytes(intermediateResponseLength) + intermediateResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            byte[] encodedValue;
            buffer.put((byte)121);
            buffer.put(TLV.getBytes(this.getIntermediateResponseLength()));
            byte[] responseNameBytes = this.getResponseNameBytes();
            if (responseNameBytes != null && responseNameBytes.length != 0) {
                buffer.put((byte)-128);
                buffer.put(TLV.getBytes(responseNameBytes.length));
                buffer.put(responseNameBytes);
            }
            if ((encodedValue = this.getResponseValue()) != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes(encodedValue.length));
                if (encodedValue.length != 0) {
                    buffer.put(encodedValue);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

