/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.reponse;

import java.util.Collection;
import java.util.List;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapResultDsml
implements DsmlDecorator<LdapResult>,
LdapResult {
    private LdapResult result;
    private Message message;
    private LdapApiService codec;

    public LdapResultDsml(LdapApiService codec, LdapResult result, Message message) {
        this.codec = codec;
        this.result = result;
        this.message = message;
    }

    @Override
    public Element toDsml(Element root) {
        Collection ldapUrls;
        Referral referral;
        Dn matchedDn;
        int requestID = this.message.getMessageId();
        if (requestID > 0) {
            root.addAttribute("requestID", "" + requestID);
        }
        if (!Dn.isNullOrEmpty((Dn)(matchedDn = this.result.getMatchedDn()))) {
            root.addAttribute("matchedDn", matchedDn.getName());
        }
        ParserUtils.addControls(this.codec, root, this.message.getControls().values());
        Element resultCodeElement = root.addElement("resultCode");
        resultCodeElement.addAttribute("code", "" + this.result.getResultCode().getResultCode());
        resultCodeElement.addAttribute("descr", this.result.getResultCode().getMessage());
        String errorMessage = this.result.getDiagnosticMessage();
        if (errorMessage != null && !errorMessage.equals("")) {
            Element errorMessageElement = root.addElement("errorMessage");
            errorMessageElement.addText(errorMessage);
        }
        if ((referral = this.result.getReferral()) != null && (ldapUrls = referral.getLdapUrls()) != null) {
            for (String ldapUrl : ldapUrls) {
                Element referalElement = root.addElement("referal");
                referalElement.addText(ldapUrl);
            }
        }
        return root;
    }

    public String getDiagnosticMessage() {
        return this.result.getDiagnosticMessage();
    }

    public void setDiagnosticMessage(String diagnosticMessage) {
        this.result.setDiagnosticMessage(diagnosticMessage);
    }

    public Dn getMatchedDn() {
        return this.result.getMatchedDn();
    }

    public void setMatchedDn(Dn matchedDn) {
        this.result.setMatchedDn(matchedDn);
    }

    public List<String> getReferrals() {
        return (List)this.result.getReferral().getLdapUrls();
    }

    public void addReferral(LdapUrl referral) {
        this.result.getReferral().addLdapUrl(referral.toString());
    }

    public ResultCodeEnum getResultCode() {
        return this.result.getResultCode();
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.result.setResultCode(resultCode);
    }

    @Override
    public LdapResult getDecorated() {
        return this.result;
    }

    public boolean isReferral() {
        return this.getDecorated().isReferral();
    }

    public Referral getReferral() {
        return this.getDecorated().getReferral();
    }

    public void setReferral(Referral referral) {
        this.getDecorated().setReferral(referral);
    }

    public boolean isDefaultSuccess() {
        return false;
    }
}

