/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.util.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnNode<N> {
    private static final Logger LOG = LoggerFactory.getLogger(DnNode.class);
    private N nodeElement;
    private Rdn nodeRdn;
    private Dn nodeDn;
    private int depth;
    private DnNode<N> parent;
    private Map<String, DnNode<N>> children;

    public DnNode() {
        this.children = new HashMap<String, DnNode<N>>();
        this.nodeDn = Dn.EMPTY_DN;
        this.nodeRdn = Rdn.EMPTY_RDN;
    }

    public DnNode(N element) {
        this.nodeElement = element;
        this.children = new HashMap<String, DnNode<N>>();
    }

    public DnNode(Dn dn, N element) {
        if (dn == null || dn.isEmpty()) {
            this.children = new HashMap<String, DnNode<N>>();
            this.nodeDn = Dn.EMPTY_DN;
            return;
        }
        try {
            DnNode<N> rootNode = this.createNode(dn, element, dn.size());
            this.children = rootNode.children;
            this.depth = rootNode.depth;
            this.nodeDn = rootNode.nodeDn;
            this.nodeElement = rootNode.nodeElement;
            this.nodeRdn = rootNode.nodeRdn;
            this.parent = null;
        }
        catch (LdapException le) {
            throw new IllegalArgumentException(le.getMessage(), le);
        }
    }

    private void checkDn(Dn dn) throws LdapException {
        if (dn == null || dn.isEmpty()) {
            String message = I18n.err(I18n.ERR_12000_CANNOT_PROCESS_EMPTY_DN, new Object[0]);
            LOG.error(message);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
        }
    }

    private DnNode<N> createNode(Dn dn, N element, int nbRdns) throws LdapException {
        this.checkDn(dn);
        DnNode<N> rootNode = null;
        for (Rdn rdn : dn.getRdns()) {
            DnNode<N> node;
            if (nbRdns == 0) break;
            if (rootNode == null) {
                node = new DnNode<N>(element);
                node.nodeRdn = rdn;
                node.nodeDn = dn;
                node.depth = dn.size() + this.depth;
                rootNode = node;
            } else {
                node = new DnNode<N>();
                node.nodeRdn = rdn;
                node.nodeDn = rootNode.nodeDn.getParent();
                node.depth = node.nodeDn.size() + this.depth;
                rootNode.parent = node;
                node.children.put(rootNode.nodeRdn.getNormName(), rootNode);
                rootNode = node;
            }
            --nbRdns;
        }
        return rootNode;
    }

    private synchronized void setElement(N element) {
        this.nodeElement = element;
    }

    public synchronized boolean isLeaf() {
        return !this.hasChildren();
    }

    public synchronized boolean isLeaf(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return false;
        }
        return node.children.size() == 0;
    }

    public synchronized int size() {
        int size = 1;
        if (this.children.size() != 0) {
            for (DnNode<N> node : this.children.values()) {
                size += node.size();
            }
        }
        return size;
    }

    public synchronized N getElement() {
        return this.nodeElement;
    }

    public synchronized N getElement(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return null;
        }
        return node.nodeElement;
    }

    public synchronized boolean hasElement() {
        return this.nodeElement != null;
    }

    public synchronized boolean hasElement(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return false;
        }
        return node.nodeElement != null;
    }

    private synchronized boolean hasDescendantElement(DnNode<N> node) {
        if (node == null) {
            return false;
        }
        if (node.hasElement()) {
            return true;
        }
        for (DnNode<N> child : node.getChildren().values()) {
            if (!this.hasDescendantElement(child)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasDescendantElement(Dn dn) {
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return false;
        }
        if (node.getDn().size() != dn.size()) {
            return false;
        }
        if (node.hasChildren()) {
            for (DnNode<N> child : node.getChildren().values()) {
                if (!this.hasDescendantElement(child)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void getDescendantElements(DnNode<N> node, List<N> descendants) {
        if (node == null) {
            return;
        }
        if (node.hasElement()) {
            descendants.add(node.getElement());
            return;
        }
        for (DnNode<N> child : node.getChildren().values()) {
            this.getDescendantElements(child, descendants);
        }
    }

    public synchronized List<N> getDescendantElements(Dn dn) {
        ArrayList descendants = new ArrayList();
        DnNode<N> node = this.getNode(dn);
        if (node == null) {
            return descendants;
        }
        if (node.getDn().size() != dn.size()) {
            return descendants;
        }
        if (node.hasChildren()) {
            for (DnNode<N> child : node.getChildren().values()) {
                this.getDescendantElements(child, descendants);
            }
        }
        return descendants;
    }

    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public synchronized boolean hasChildren(Dn dn) throws LdapException {
        this.checkDn(dn);
        DnNode<N> node = this.getNode(dn);
        return node != null && node.hasChildren();
    }

    public synchronized Map<String, DnNode<N>> getChildren() {
        return this.children;
    }

    public synchronized DnNode<N> getParent() {
        return this.parent;
    }

    public synchronized boolean hasParent() {
        return this.parent != null;
    }

    public synchronized boolean hasParent(Dn dn) {
        List<Rdn> rdns = dn.getRdns();
        DnNode<N> currentNode = this;
        DnNode<N> parentNode = null;
        for (int i = rdns.size() - 1; i >= 0; --i) {
            Rdn rdn = rdns.get(i);
            if (rdn.equals(currentNode.nodeRdn)) {
                parentNode = currentNode;
                continue;
            }
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn.getNormName())) == null) break;
            parentNode = currentNode;
        }
        return parentNode != null;
    }

    public synchronized DnNode<N> add(Dn dn) throws LdapException {
        return this.add(dn, null);
    }

    public synchronized DnNode<N> add(Dn dn, N element) throws LdapException {
        this.checkDn(dn);
        DnNode<N> parentNode = this.getNode(dn);
        if (parentNode == null) {
            DnNode<N> childNode = this.createNode(dn, element, dn.size());
            childNode.parent = this;
            this.children.put(childNode.nodeRdn.getNormName(), childNode);
            return childNode;
        }
        int nbRdns = dn.size() - parentNode.depth;
        if (nbRdns == 0) {
            if (parentNode.hasElement()) {
                String message = I18n.err(I18n.ERR_12001_CANNOT_ADD_NODE_CHILD_EXISTS, new Object[0]);
                LOG.error(message);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
            }
            if (element == null) {
                String message = I18n.err(I18n.ERR_12002_CANNOT_ADD_NODE_ALREADY_EXISTS, new Object[0]);
                LOG.error(message);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
            }
            super.setElement(element);
            return parentNode;
        }
        DnNode<N> childNode = this.createNode(dn, element, nbRdns);
        childNode.parent = parentNode;
        parentNode.children.put(childNode.nodeRdn.getNormName(), childNode);
        return childNode;
    }

    public synchronized void remove(Dn dn) throws LdapException {
        this.checkDn(dn);
        DnNode<N> parentNode = this.getNode(dn);
        if (parentNode == null) {
            return;
        }
        if (dn.size() != parentNode.depth || parentNode.hasChildren()) {
            return;
        }
        parentNode = parentNode.getParent();
        for (Rdn rdn : dn.getRdns()) {
            parentNode.children.remove(rdn.getNormName());
            if (parentNode.children.size() > 0) break;
            parentNode = parentNode.getParent();
        }
    }

    public synchronized boolean contains(Rdn rdn) {
        return this.children.containsKey(rdn.getNormName());
    }

    public synchronized DnNode<N> getChild(Rdn rdn) {
        if (this.children.containsKey(rdn.getNormName())) {
            return this.children.get(rdn.getNormName());
        }
        return null;
    }

    public synchronized Rdn getRdn() {
        return this.nodeRdn;
    }

    public synchronized DnNode<N> getNode(Dn dn) {
        DnNode<N> currentNode = this;
        DnNode<N> parentNode = null;
        for (int i = dn.size() - 1; i >= 0; --i) {
            Rdn rdn = dn.getRdn(i);
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn.getNormName())) == null) break;
            parentNode = currentNode;
        }
        return parentNode;
    }

    public synchronized boolean hasParentElement(Dn dn) {
        List<Rdn> rdns = dn.getRdns();
        DnNode<N> currentNode = this;
        boolean hasElement = false;
        for (int i = rdns.size() - 1; i >= 0; --i) {
            Rdn rdn = rdns.get(i);
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn.getNormName())) == null) break;
            if (currentNode.hasElement()) {
                hasElement = true;
            }
            this.parent = currentNode;
        }
        return hasElement;
    }

    public synchronized DnNode<N> getParentWithElement(Dn dn) {
        List<Rdn> rdns = dn.getRdns();
        DnNode<N> currentNode = this;
        DnNode<N> element = null;
        for (int i = rdns.size() - 1; i >= 1; --i) {
            Rdn rdn = rdns.get(i);
            if (!currentNode.hasChildren() || (currentNode = currentNode.children.get(rdn.getNormName())) == null) break;
            if (currentNode.hasElement()) {
                element = currentNode;
            }
            this.parent = currentNode;
        }
        return element;
    }

    public synchronized DnNode<N> getParentWithElement() {
        DnNode<N> currentNode = this.parent;
        while (currentNode != null) {
            if (currentNode.nodeElement != null) {
                return currentNode;
            }
            currentNode = currentNode.parent;
        }
        return null;
    }

    public synchronized void rename(Rdn newRdn) throws LdapException {
        Dn temp = this.nodeDn.getParent();
        temp = temp.add(newRdn);
        Rdn oldRdn = this.nodeRdn;
        this.nodeRdn = temp.getRdn();
        this.nodeDn = temp;
        if (this.parent != null) {
            this.parent.children.remove(oldRdn.getNormName());
            this.parent.children.put(this.nodeRdn.getNormName(), this);
        }
        this.updateAfterModDn(this.nodeDn);
    }

    public synchronized void move(Dn newParent) throws LdapException {
        DnNode<N> tmp = null;
        Dn tmpDn = null;
        if (newParent.isDescendantOf(this.parent.nodeDn)) {
            tmp = this.parent;
            tmpDn = this.parent.nodeDn;
        }
        if (tmpDn != null) {
            int parentNodeSize = tmpDn.size();
            int count = newParent.size() - parentNodeSize;
            while (count-- > 0) {
                tmp = tmp.getChild(newParent.getRdn(parentNodeSize++));
            }
        }
        if (tmp == null) {
            tmp = this;
            while (tmp.parent != null) {
                tmp = tmp.parent;
            }
            tmp = tmp.getNode(newParent);
        }
        this.nodeDn = newParent.add(this.nodeRdn);
        super.updateAfterModDn(this.nodeDn);
        if (this.parent != null) {
            this.parent.children.remove(this.nodeRdn.getNormName());
        }
        this.parent = tmp;
        this.parent.children.put(this.nodeRdn.getNormName(), this);
    }

    private synchronized void updateAfterModDn(Dn newParentDn) throws LdapInvalidDnException {
        if (this.children != null) {
            for (DnNode<N> child : this.children.values()) {
                child.nodeDn = newParentDn.add(child.nodeRdn);
                super.updateAfterModDn(child.nodeDn);
            }
        }
    }

    private String toString(String tabs) {
        if (this.nodeRdn == null) {
            return tabs;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tabs);
        boolean hasChildren = this.hasChildren();
        if (this.isLeaf()) {
            sb.append("Leaf[").append(this.nodeDn).append("]: ").append("'").append(this.nodeElement).append("'");
            return sb.toString();
        }
        sb.append("Branch[").append(this.nodeDn).append("]: ");
        if (this.nodeElement != null) {
            sb.append("'").append(this.nodeElement).append("'");
        }
        tabs = tabs + "    ";
        sb.append('\n');
        boolean isFirst = true;
        if (hasChildren) {
            for (Map.Entry<String, DnNode<N>> entry : this.children.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append("\n");
                }
                DnNode<N> child = entry.getValue();
                sb.append(super.toString(tabs));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public synchronized Dn getDn() {
        return this.nodeDn;
    }
}

