/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.ValidatingPoolableLdapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionPool
extends GenericObjectPool<LdapConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnectionPool.class);
    private PooledObjectFactory<LdapConnection> factory;

    public LdapConnectionPool(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout) {
        this(connectionConfig, apiService, timeout, null);
    }

    public LdapConnectionPool(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout, GenericObjectPoolConfig poolConfig) {
        this(LdapConnectionPool.newPoolableConnectionFactory(connectionConfig, apiService, timeout), poolConfig);
    }

    public LdapConnectionPool(PooledObjectFactory<LdapConnection> factory) {
        this(factory, null);
    }

    public LdapConnectionPool(PooledObjectFactory<LdapConnection> factory, GenericObjectPoolConfig poolConfig) {
        super(factory, poolConfig == null ? new GenericObjectPoolConfig() : poolConfig);
        this.factory = factory;
    }

    public LdapApiService getLdapApiService() {
        return ((AbstractPoolableLdapConnectionFactory)this.factory).getLdapApiService();
    }

    public LdapConnection getConnection() throws LdapException {
        LdapConnection connection;
        try {
            connection = (LdapConnection)super.borrowObject();
            if (LOG.isTraceEnabled()) {
                LOG.trace(I18n.msg(I18n.MSG_04163_BORROWED_CONNECTION, connection));
            }
        }
        catch (RuntimeException | LdapException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_04107_UNEXPECTED_THROWN_EXCEPTION, e.getMessage()), e);
            throw new RuntimeException(e);
        }
        return connection;
    }

    private static ValidatingPoolableLdapConnectionFactory newPoolableConnectionFactory(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout) {
        DefaultLdapConnectionFactory connectionFactory = new DefaultLdapConnectionFactory(connectionConfig);
        connectionFactory.setLdapApiService(apiService);
        connectionFactory.setTimeOut(timeout);
        return new ValidatingPoolableLdapConnectionFactory(connectionFactory);
    }

    public void releaseConnection(LdapConnection connection) throws LdapException {
        try {
            super.returnObject((Object)connection);
            if (LOG.isTraceEnabled()) {
                LOG.trace(I18n.msg(I18n.MSG_04164_RETURNED_CONNECTION, connection));
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_04107_UNEXPECTED_THROWN_EXCEPTION, e.getMessage()), e);
            throw new RuntimeException(e);
        }
    }
}

