/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.ldap.client.template.PasswordPolicyOperation;
import org.apache.directory.ldap.client.template.PasswordPolicyResponder;
import org.apache.directory.ldap.client.template.PasswordWarning;
import org.apache.directory.ldap.client.template.PasswordWarningImpl;
import org.apache.directory.ldap.client.template.exception.PasswordException;

public abstract class AbstractPasswordPolicyResponder
implements PasswordPolicyResponder {
    private final PasswordPolicyDecorator passwordPolicyRequestControl;

    protected AbstractPasswordPolicyResponder(LdapApiService ldapApiService) {
        this.passwordPolicyRequestControl = new PasswordPolicyDecorator(ldapApiService);
    }

    protected PasswordException exception(LdapException e) {
        return new PasswordException().setLdapException(e);
    }

    protected PasswordException fail(ResultResponse resultResponse, PasswordPolicy passwordPolicy, ResultCodeEnum resultCode) {
        PasswordException exception = new PasswordException();
        exception.setResultCode(resultCode);
        if (passwordPolicy != null && passwordPolicy.getResponse() != null && passwordPolicy.getResponse().getPasswordPolicyError() != null) {
            exception.setPasswordPolicyError(passwordPolicy.getResponse().getPasswordPolicyError());
        }
        return exception;
    }

    private PasswordPolicy getPasswordPolicy(Response response) {
        Control control = response.getControls().get(this.passwordPolicyRequestControl.getOid());
        return control == null ? null : (PasswordPolicy)((PasswordPolicyDecorator)control).getDecorated();
    }

    @Override
    public final PasswordWarning process(PasswordPolicyOperation operation) throws PasswordException {
        try {
            ResultResponse response = operation.process();
            PasswordPolicy passwordPolicy = this.getPasswordPolicy(response);
            ResultCodeEnum resultCode = response.getLdapResult().getResultCode();
            if (resultCode == ResultCodeEnum.SUCCESS) {
                return this.success(passwordPolicy);
            }
            throw this.fail(response, passwordPolicy, resultCode);
        }
        catch (LdapException e) {
            throw new PasswordException().setLdapException(e);
        }
    }

    protected PasswordWarning success(PasswordPolicy passwordPolicy) {
        return passwordPolicy == null ? null : PasswordWarningImpl.newWarning(passwordPolicy);
    }
}

