/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.TLVBerDecoderMBean;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.asn1.util.Asn1StringUtils;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asn1Decoder
implements TLVBerDecoderMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Asn1Decoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final boolean MORE = true;
    private static final boolean END = false;
    private boolean indefiniteLengthAllowed = false;
    private int maxLengthLength = 1;
    private int maxTagLength = 1;

    private boolean treatTagStartState(ByteBuffer stream, Asn1Container container) {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = new TLV(container.getNewTlvId());
            tlv.setTag(octet);
            container.setCurrentTLV(tlv);
            tlv.setParent(container.getParentTLV());
            container.setState(TLVStateEnum.LENGTH_STATE_START);
            if (IS_DEBUG) {
                byte tag = container.getCurrentTLV().getTag();
                LOG.debug("Tag {} has been decoded", (Object)Asn1StringUtils.dumpByte(tag));
            }
            return true;
        }
        return false;
    }

    private void dumpTLVTree(Asn1Container container) {
        StringBuffer sb = new StringBuffer();
        TLV current = container.getCurrentTLV();
        sb.append("TLV").append(Asn1StringUtils.dumpByte(current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        for (current = current.getParent(); current != null; current = current.getParent()) {
            sb.append("-TLV").append(Asn1StringUtils.dumpByte(current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        }
        if (IS_DEBUG) {
            LOG.debug("TLV Tree : {}", (Object)sb.toString());
        }
    }

    private boolean isTLVDecoded(Asn1Container container) {
        TLV current = container.getCurrentTLV();
        for (TLV parent = current.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getExpectedLength() == 0) continue;
            return false;
        }
        BerValue value = current.getValue();
        if (value != null && value.getData() != null) {
            return current.getExpectedLength() == value.getData().length;
        }
        return current.getExpectedLength() == 0;
    }

    private boolean treatLengthStartState(ByteBuffer stream, Asn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = container.getCurrentTLV();
            if ((octet & 0x80) == 0) {
                tlv.setLength(octet);
                tlv.setLengthNbBytes(1);
                container.setState(TLVStateEnum.LENGTH_STATE_END);
            } else if ((octet & 0x7F) != 127) {
                int expectedLength = octet & 0x7F;
                if (expectedLength > 4) {
                    String msg = I18n.err(I18n.ERR_00005_LENGTH_OVERFLOW, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                tlv.setLength(0);
                tlv.setLengthNbBytes(1 + expectedLength);
                tlv.setLengthBytesRead(1);
                container.setState(TLVStateEnum.LENGTH_STATE_PENDING);
            } else {
                String msg = I18n.err(I18n.ERR_00006_LENGTH_EXTENSION_RESERVED, new Object[0]);
                LOG.error(msg);
                throw new DecoderException(msg);
            }
            return true;
        }
        return false;
    }

    private boolean treatLengthPendingState(ByteBuffer stream, Asn1Container container) {
        if (stream.hasRemaining()) {
            TLV tlv = container.getCurrentTLV();
            int length = tlv.getLength();
            while (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                byte octet = stream.get();
                if (IS_DEBUG) {
                    LOG.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                }
                tlv.incLengthBytesRead();
                length = length << 8 | octet & 0xFF;
                if (stream.hasRemaining()) continue;
                tlv.setLength(length);
                if (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                    container.setState(TLVStateEnum.LENGTH_STATE_PENDING);
                    return false;
                }
                container.setState(TLVStateEnum.LENGTH_STATE_END);
                return true;
            }
            tlv.setLength(length);
            container.setState(TLVStateEnum.LENGTH_STATE_END);
            return true;
        }
        return false;
    }

    private String getParentLength(TLV tlv) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TLV expected length stack : ");
        while (true) {
            if (tlv == null) break;
            buffer.append(" - ").append(tlv.getExpectedLength());
            tlv = tlv.getParent();
        }
        buffer.append(" - null");
        return buffer.toString();
    }

    private void treatLengthEndState(Asn1Container container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv == null) {
            String msg = I18n.err(I18n.ERR_00007_TLV_NULL, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        int length = tlv.getLength();
        TLV parentTLV = container.getParentTLV();
        if (IS_DEBUG) {
            LOG.debug("Parent length : {}", (Object)this.getParentLength(parentTLV));
        }
        if (parentTLV == null) {
            tlv.setExpectedLength(length);
            container.setParentTLV(tlv);
            if (IS_DEBUG) {
                LOG.debug("Root TLV[{}]", (Object)length);
            }
        } else {
            int currentLength;
            int expectedLength = parentTLV.getExpectedLength();
            if (expectedLength < (currentLength = tlv.getSize())) {
                LOG.debug("tlv[{}, {}]", (Object)expectedLength, (Object)currentLength);
                throw new DecoderException(I18n.err(I18n.ERR_00008_VALUE_LENGTH_ABOVE_EXPECTED_LENGTH, currentLength, expectedLength));
            }
            if (expectedLength == currentLength) {
                parentTLV.setExpectedLength(0);
                if (tlv.isConstructed()) {
                    if (length == 0) {
                        while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                            parentTLV = parentTLV.getParent();
                        }
                        container.setParentTLV(parentTLV);
                    } else {
                        container.setParentTLV(tlv);
                    }
                    tlv.setParent(parentTLV);
                    tlv.setExpectedLength(length);
                } else {
                    tlv.setExpectedLength(length);
                    while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                        parentTLV = parentTLV.getParent();
                    }
                    container.setParentTLV(parentTLV);
                }
            } else {
                parentTLV.setExpectedLength(expectedLength - currentLength);
                tlv.setExpectedLength(length);
                if (tlv.isConstructed()) {
                    tlv.setParent(parentTLV);
                    container.setParentTLV(tlv);
                }
            }
        }
        if (IS_DEBUG) {
            LOG.debug("Length {} has been decoded", (Object)length);
        }
        if (length == 0) {
            container.setState(TLVStateEnum.TLV_STATE_DONE);
        } else {
            container.setState(TLVStateEnum.VALUE_STATE_START);
        }
    }

    private boolean treatValueStartState(ByteBuffer stream, Asn1Container container) {
        TLV currentTlv = container.getCurrentTLV();
        if (TLV.isConstructed(currentTlv.getTag()) && !container.isGathering()) {
            container.setState(TLVStateEnum.TLV_STATE_DONE);
            return true;
        }
        int length = currentTlv.getLength();
        int nbBytes = stream.remaining();
        if (nbBytes < length) {
            currentTlv.getValue().init(length);
            currentTlv.getValue().setData(stream);
            container.setState(TLVStateEnum.VALUE_STATE_PENDING);
            return false;
        }
        currentTlv.getValue().init(length);
        stream.get(currentTlv.getValue().getData(), 0, length);
        container.setState(TLVStateEnum.TLV_STATE_DONE);
        return true;
    }

    private boolean treatValuePendingState(ByteBuffer stream, Asn1Container container) {
        int nbBytes;
        TLV currentTlv = container.getCurrentTLV();
        int length = currentTlv.getLength();
        int currentLength = currentTlv.getValue().getCurrentLength();
        if (currentLength + (nbBytes = stream.remaining()) < length) {
            currentTlv.getValue().addData(stream);
            container.setState(TLVStateEnum.VALUE_STATE_PENDING);
            return false;
        }
        int remaining = length - currentLength;
        byte[] data = new byte[remaining];
        stream.get(data, 0, remaining);
        currentTlv.getValue().addData(data);
        container.setState(TLVStateEnum.TLV_STATE_DONE);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean treatTLVDoneState(ByteBuffer stream, Asn1Container container) throws DecoderException {
        if (IS_DEBUG) {
            this.dumpTLVTree(container);
        }
        container.getGrammar().executeAction(container);
        if (!this.isTLVDecoded(container)) {
            container.setState(TLVStateEnum.TAG_STATE_START);
            return stream.hasRemaining();
        }
        if (container.getState() == TLVStateEnum.GRAMMAR_END) {
            container.setState(TLVStateEnum.PDU_DECODED);
            return stream.hasRemaining();
        }
        if (container.isGrammarEndAllowed()) {
            container.setState(TLVStateEnum.PDU_DECODED);
            return stream.hasRemaining();
        }
        LOG.error(I18n.err(I18n.ERR_00009_MORE_TLV_EXPECTED, new Object[0]));
        throw new DecoderException(I18n.err(I18n.ERR_00010_TRUNCATED_PDU, new Object[0]));
    }

    public void decode(ByteBuffer stream, Asn1Container container) throws DecoderException {
        boolean hasRemaining = stream.hasRemaining();
        container.incrementDecodedBytes(stream.remaining());
        if (container.getDecodedBytes() > container.getMaxPDUSize()) {
            String message = I18n.err(I18n.ERR_00042_PDU_SIZE_TOO_LONG, container.getDecodedBytes(), container.getMaxPDUSize());
            LOG.error(message);
            throw new DecoderException(message);
        }
        if (IS_DEBUG) {
            LOG.debug(">>>==========================================");
            LOG.debug("--> Decoding a PDU");
            LOG.debug(">>>------------------------------------------");
        }
        block11: while (hasRemaining) {
            if (IS_DEBUG) {
                LOG.debug("--- State = {} ---", (Object)container.getState());
                if (stream.hasRemaining()) {
                    byte octet = stream.get(stream.position());
                    LOG.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                } else {
                    LOG.debug("  no more byte to decode in the stream");
                }
            }
            switch (container.getState()) {
                case TAG_STATE_START: {
                    container.setGrammarEndAllowed(false);
                    hasRemaining = this.treatTagStartState(stream, container);
                    continue block11;
                }
                case LENGTH_STATE_START: {
                    hasRemaining = this.treatLengthStartState(stream, container);
                    continue block11;
                }
                case LENGTH_STATE_PENDING: {
                    hasRemaining = this.treatLengthPendingState(stream, container);
                    continue block11;
                }
                case LENGTH_STATE_END: {
                    this.treatLengthEndState(container);
                    continue block11;
                }
                case VALUE_STATE_START: {
                    hasRemaining = this.treatValueStartState(stream, container);
                    continue block11;
                }
                case VALUE_STATE_PENDING: {
                    hasRemaining = this.treatValuePendingState(stream, container);
                    continue block11;
                }
                case VALUE_STATE_END: {
                    hasRemaining = stream.hasRemaining();
                    continue block11;
                }
                case TLV_STATE_DONE: {
                    hasRemaining = this.treatTLVDoneState(stream, container);
                    continue block11;
                }
                case PDU_DECODED: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_00043_REMAINING_BYTES_FOR_DECODED_PDU, new Object[0]));
                    }
                    hasRemaining = false;
                    continue block11;
                }
            }
        }
        if (IS_DEBUG) {
            LOG.debug("<<<------------------------------------------");
            if (container.getState() == TLVStateEnum.PDU_DECODED) {
                if (container.getCurrentTLV() != null) {
                    LOG.debug("<-- Stop decoding : {}", (Object)container.getCurrentTLV().toString());
                } else {
                    LOG.debug("<-- Stop decoding : null current TLV");
                }
            } else if (container.getCurrentTLV() != null) {
                LOG.debug("<-- End decoding : {}", (Object)container.getCurrentTLV().toString());
            } else {
                LOG.debug("<-- End decoding : null current TLV");
            }
            LOG.debug("<<<==========================================");
        }
    }

    @Override
    public int getMaxLengthLength() {
        return this.maxLengthLength;
    }

    @Override
    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    @Override
    public void disallowIndefiniteLength() {
        this.indefiniteLengthAllowed = false;
    }

    @Override
    public void allowIndefiniteLength() {
        this.indefiniteLengthAllowed = true;
    }

    @Override
    public boolean isIndefiniteLengthAllowed() {
        return this.indefiniteLengthAllowed;
    }

    @Override
    public void setMaxLengthLength(int maxLengthLength) throws DecoderException {
        if (this.indefiniteLengthAllowed && maxLengthLength > 126) {
            throw new DecoderException(I18n.err(I18n.ERR_00011_LENGTH_TOO_LONG_FOR_DEFINITE_FORM, new Object[0]));
        }
        this.maxLengthLength = maxLengthLength;
    }

    @Override
    public void setMaxTagLength(int maxTagLength) {
        this.maxTagLength = maxTagLength;
    }
}

