/*
 *   Licensed to the Apache Software Foundation (ASF) under one
 *   or more contributor license agreements.  See the NOTICE file
 *   distributed with this work for additional information
 *   regarding copyright ownership.  The ASF licenses this file
 *   to you under the Apache License, Version 2.0 (the
 *   "License"); you may not use this file except in compliance
 *   with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing,
 *   software distributed under the License is distributed on an
 *   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *   KIND, either express or implied.  See the License for the
 *   specific language governing permissions and limitations
 *   under the License.
 *
 */
package org.apache.directory.ldap.client.template;


import org.apache.directory.api.ldap.model.exception.LdapException;


/**
 * Edits a supplied request adding specifics.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public interface RequestBuilder<T>
{
    /**
     * Modifies the provided request adding specific information to it.
     * The supplied request is typically a factory built request with just
     * its Dn set.  It is the responsibility of this method to fill in all
     * of the details.  The request will be sent to the LDAP server upon
     * upon returning from this method.
     *
     * @param request The request to be modified
     * @throws LdapException If something goes wrong
     */
    public void buildRequest( T request ) throws LdapException;
}
