/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPoolableLdapConnectionFactory
extends AbstractPoolableLdapConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPoolableLdapConnectionFactory.class);

    public DefaultPoolableLdapConnectionFactory(LdapConnectionConfig config) {
        this(new DefaultLdapConnectionFactory(config));
    }

    public DefaultPoolableLdapConnectionFactory(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void activateObject(LdapConnection connection) {
        LOG.debug("Activating {}", (Object)connection);
    }

    public void destroyObject(LdapConnection connection) {
        LOG.debug("Destroying {}", (Object)connection);
        if (connection.isConnected()) {
            try {
                connection.unBind();
            }
            catch (LdapException e) {
                LOG.error("unable to unbind connection: {}", (Object)e.getMessage());
                LOG.debug("unable to unbind connection:", (Throwable)e);
            }
        }
        try {
            connection.close();
        }
        catch (IOException e) {
            LOG.error("unable to close connection: {}", (Object)e.getMessage());
            LOG.debug("unable to close connection:", (Throwable)e);
        }
    }

    public LdapConnection makeObject() throws LdapException {
        LOG.debug("Creating a LDAP connection");
        return this.connectionFactory.newLdapConnection();
    }

    public void passivateObject(LdapConnection connection) throws LdapException {
        LOG.debug("Passivating {}", (Object)connection);
    }

    public boolean validateObject(LdapConnection connection) {
        LOG.debug("Validating {}", (Object)connection);
        if (connection.isConnected()) {
            if (connection.isAuthenticated()) {
                return true;
            }
            try {
                this.connectionFactory.bindConnection(connection);
                return true;
            }
            catch (LdapException le) {
                return false;
            }
        }
        return false;
    }
}

