/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.AbstractValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;

public class StringValue
extends AbstractValue<String> {
    private static final long serialVersionUID = 2L;
    private byte[] bytes;

    public StringValue(AttributeType attributeType) {
        if (attributeType != null) {
            if (attributeType.getSyntax() == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04445, new Object[0]));
            }
            if (!attributeType.getSyntax().isHumanReadable()) {
                LOG.warn("Treating a value of a binary attribute {} as a String: \nthis could cause data corruption!", (Object)attributeType.getName());
            }
            this.attributeType = attributeType;
        }
    }

    public StringValue(String value) {
        this.wrappedValue = value;
        this.normalizedValue = value;
        this.bytes = Strings.getBytesUtf8(value);
    }

    public StringValue(AttributeType attributeType, String value) throws LdapInvalidAttributeValueException {
        this(value);
        this.apply(attributeType);
    }

    @Override
    public String getValue() {
        return (String)this.wrappedValue;
    }

    @Override
    public String getNormValue() {
        return (String)this.normalizedValue;
    }

    @Override
    public int compareTo(Value<String> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (!(value instanceof StringValue)) {
            String message = I18n.err(I18n.ERR_04128, this.toString(), value.getClass());
            LOG.error(message);
            throw new NotImplementedException(message);
        }
        StringValue stringValue = (StringValue)value;
        if (this.attributeType != null) {
            if (stringValue.getAttributeType() == null) {
                return this.getNormValue().compareTo(stringValue.getNormValue());
            }
            if (!this.attributeType.equals(stringValue.getAttributeType())) {
                String message = I18n.err(I18n.ERR_04128, this.toString(), value.getClass());
                LOG.error(message);
                throw new NotImplementedException(message);
            }
        } else {
            return this.getNormValue().compareTo(stringValue.getNormValue());
        }
        try {
            return this.getLdapComparator().compare(this.getNormValue(), stringValue.getNormValue());
        }
        catch (LdapException e) {
            String msg = I18n.err(I18n.ERR_04443, this, value);
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public StringValue clone() {
        return (StringValue)super.clone();
    }

    public int hashCode() {
        if (this.h == 0) {
            if (this.isNull()) {
                return 0;
            }
            String normalized = this.getNormValue();
            this.h = normalized != null ? normalized.hashCode() : 17;
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringValue)) {
            return false;
        }
        StringValue other = (StringValue)obj;
        if (this.attributeType != null) {
            if (other.attributeType != null) {
                if (this.attributeType.getOid().equals(other.getAttributeType().getOid())) {
                    if (this.isNull()) {
                        return other.isNull();
                    }
                    if (((String)this.wrappedValue).equals(other.wrappedValue)) {
                        return true;
                    }
                    try {
                        LdapComparator comparator = this.getLdapComparator();
                        if (comparator == null) {
                            return ((String)this.getNormReference()).equals(other.getNormReference());
                        }
                        return comparator.compare(this.getNormReference(), other.getNormReference()) == 0;
                    }
                    catch (LdapException ne) {
                        return false;
                    }
                }
                return false;
            }
            if (this.isNull()) {
                return other.isNull();
            }
            try {
                LdapComparator comparator = this.getLdapComparator();
                MatchingRule equality = this.getAttributeType().getEquality();
                if (equality == null) {
                    return ((String)this.getNormReference()).equals(other.getNormReference());
                }
                Normalizer normalizer = equality.getNormalizer();
                StringValue otherValue = (StringValue)normalizer.normalize(other);
                if (comparator == null) {
                    return ((String)this.getNormReference()).equals(otherValue.getNormReference());
                }
                return comparator.compare(this.getNormReference(), otherValue.getNormReference()) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        if (other.attributeType != null) {
            if (this.isNull()) {
                return other.isNull();
            }
            try {
                LdapComparator comparator = other.getLdapComparator();
                MatchingRule equality = other.getAttributeType().getEquality();
                if (equality == null) {
                    return ((String)this.getNormReference()).equals(other.getNormReference());
                }
                Normalizer normalizer = equality.getNormalizer();
                StringValue thisValue = (StringValue)normalizer.normalize(this);
                if (comparator == null) {
                    return ((String)thisValue.getNormReference()).equals(other.getNormReference());
                }
                return comparator.compare(thisValue.getNormReference(), other.getNormReference()) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        if (this.isNull()) {
            return other.isNull();
        }
        return ((String)this.getNormReference()).equals(other.getNormReference());
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public int length() {
        return this.wrappedValue != null ? ((String)this.wrappedValue).length() : 0;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getString() {
        return this.wrappedValue != null ? (String)this.wrappedValue : "";
    }

    public static StringValue deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        StringValue value = new StringValue((AttributeType)null);
        value.readExternal(in);
        return value;
    }

    public static StringValue deserialize(AttributeType attributeType, ObjectInput in) throws IOException, ClassNotFoundException {
        StringValue value = new StringValue(attributeType);
        value.readExternal(in);
        return value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        block11: {
            boolean normalized;
            boolean isHR = in.readBoolean();
            if (!isHR) {
                throw new IOException("The serialized value is not a String value");
            }
            if (in.readBoolean()) {
                this.wrappedValue = in.readUTF();
                this.bytes = Strings.getBytesUtf8((String)this.wrappedValue);
            }
            if (normalized = in.readBoolean()) {
                if (in.readBoolean()) {
                    this.normalizedValue = in.readUTF();
                }
            } else if (this.attributeType != null) {
                try {
                    MatchingRule equality = this.attributeType.getEquality();
                    if (equality == null) {
                        this.normalizedValue = this.wrappedValue;
                        break block11;
                    }
                    Normalizer normalizer = equality.getNormalizer();
                    if (normalizer != null) {
                        this.normalizedValue = normalizer.normalize((String)this.wrappedValue);
                        break block11;
                    }
                    this.normalizedValue = this.wrappedValue;
                }
                catch (LdapException le) {
                    this.normalizedValue = this.wrappedValue;
                }
            } else {
                this.normalizedValue = this.wrappedValue;
            }
        }
        this.h = in.readInt();
    }

    public int serialize(byte[] buffer, int pos) {
        int length = 7;
        byte[] wrappedValueBytes = null;
        byte[] normalizedValueBytes = null;
        if (this.wrappedValue != null) {
            wrappedValueBytes = Strings.getBytesUtf8((String)this.wrappedValue);
            length += 4 + wrappedValueBytes.length;
        }
        if (this.attributeType != null) {
            if (this.normalizedValue != null) {
                normalizedValueBytes = Strings.getBytesUtf8((String)this.normalizedValue);
                length += 5 + normalizedValueBytes.length;
            } else {
                ++length;
            }
        }
        if (buffer.length - pos < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        buffer[pos] = 1;
        ++pos;
        if (this.wrappedValue != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize(wrappedValueBytes, buffer, pos);
        } else {
            buffer[pos++] = 0;
        }
        if (this.attributeType != null) {
            buffer[pos++] = 1;
            if (this.normalizedValue != null) {
                buffer[pos++] = 1;
                pos = Serialize.serialize(normalizedValueBytes, buffer, pos);
            } else {
                buffer[pos++] = 0;
            }
        } else {
            buffer[pos++] = 0;
        }
        pos = Serialize.serialize(this.h, buffer, pos);
        return pos;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException {
        block12: {
            if (pos < 0 || pos >= buffer.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            boolean isHR = Serialize.deserializeBoolean(buffer, pos);
            ++pos;
            if (!isHR) {
                throw new IOException("The serialized value is not a String value");
            }
            boolean hasWrappedValue = Serialize.deserializeBoolean(buffer, pos);
            ++pos;
            if (hasWrappedValue) {
                byte[] wrappedValueBytes = Serialize.deserializeBytes(buffer, pos);
                pos += 4 + wrappedValueBytes.length;
                this.wrappedValue = Strings.utf8ToString(wrappedValueBytes);
            }
            boolean hasAttributeType = Serialize.deserializeBoolean(buffer, pos);
            ++pos;
            if (hasAttributeType) {
                boolean hasNormalizedValue = Serialize.deserializeBoolean(buffer, pos);
                ++pos;
                if (hasNormalizedValue) {
                    byte[] normalizedValueBytes = Serialize.deserializeBytes(buffer, pos);
                    pos += 4 + normalizedValueBytes.length;
                    this.normalizedValue = Strings.utf8ToString(normalizedValueBytes);
                }
            } else if (this.attributeType != null) {
                try {
                    MatchingRule equality = this.attributeType.getEquality();
                    if (equality == null) {
                        this.normalizedValue = this.wrappedValue;
                        break block12;
                    }
                    Normalizer normalizer = equality.getNormalizer();
                    if (normalizer != null) {
                        this.normalizedValue = normalizer.normalize((String)this.wrappedValue);
                        break block12;
                    }
                    this.normalizedValue = this.wrappedValue;
                }
                catch (LdapException le) {
                    this.normalizedValue = this.wrappedValue;
                }
            } else {
                this.normalizedValue = this.wrappedValue;
            }
        }
        this.h = Serialize.deserializeInt(buffer, pos);
        return pos += 4;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(true);
        if (this.wrappedValue != null) {
            out.writeBoolean(true);
            out.writeUTF((String)this.wrappedValue);
        } else {
            out.writeBoolean(false);
        }
        if (this.attributeType != null) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeBoolean(true);
                out.writeUTF((String)this.normalizedValue);
            } else {
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.h);
        out.flush();
    }

    public String toString() {
        return this.wrappedValue == null ? "null" : (String)this.wrappedValue;
    }
}

