/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci.protectedItem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.model.entry.Attribute;

public class AttributeValueItem
extends ProtectedItem {
    private final Set<Attribute> attributes;

    public AttributeValueItem(Set<Attribute> attributes) {
        this.attributes = Collections.unmodifiableSet(attributes);
    }

    public Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.attributes.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof AttributeValueItem) {
            AttributeValueItem that = (AttributeValueItem)o;
            return this.attributes.equals(that.attributes);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("attributeValue {");
        boolean isFirst = true;
        for (Attribute attribute : this.attributes) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(attribute.getId());
            buf.append('=');
            buf.append(attribute.get());
        }
        buf.append(" }");
        return buf.toString();
    }
}

