/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directmemory.server.commons;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.directmemory.serialization.Serializer;
import org.apache.directmemory.server.commons.DirectMemoryException;
import org.apache.directmemory.server.commons.DirectMemoryRequest;
import org.apache.directmemory.server.commons.DirectMemoryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectMemoryWriter {
    private JsonFactory jsonFactory;
    private static final DirectMemoryWriter INSTANCE = new DirectMemoryWriter();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public static DirectMemoryWriter instance() {
        return INSTANCE;
    }

    private DirectMemoryWriter() {
        this.jsonFactory = new JsonFactory();
    }

    public String generateJsonRequest(DirectMemoryRequest request) throws DirectMemoryException {
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator g = this.jsonFactory.createJsonGenerator((Writer)stringWriter);
            g.writeStartObject();
            g.writeStringField("key", request.getKey());
            g.writeBooleanField("put", request.isUpdate());
            g.writeNumberField("expiresIn", request.getExpiresIn());
            Serializer serializer = request.getSerializer();
            byte[] bytes = request.getObject() != null ? request.getSerializer().serialize(request.getObject()) : request.getCacheContent();
            g.writeFieldName("cacheContent");
            g.writeBinary(bytes);
            if (serializer != null) {
                g.writeStringField("serializer", serializer.getClass().getName());
            }
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            throw new DirectMemoryException(e.getMessage(), e);
        }
        return stringWriter.toString();
    }

    public String generateJsonResponse(DirectMemoryResponse response) throws DirectMemoryException {
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator g = this.jsonFactory.createJsonGenerator((Writer)stringWriter);
            g.writeStartObject();
            g.writeBooleanField("found", response.isFound());
            g.writeStringField("key", response.getKey());
            if (response.getCacheContent() != null && response.getCacheContent().length > 0) {
                g.writeFieldName("cacheContent");
                g.writeBinary(response.getCacheContent());
            }
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            throw new DirectMemoryException(e.getMessage(), e);
        }
        return stringWriter.toString();
    }
}

