/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directmemory.server.commons;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.apache.directmemory.server.commons.DirectMemoryException;
import org.apache.directmemory.server.commons.DirectMemoryRequest;
import org.apache.directmemory.server.commons.DirectMemoryResponse;

public class DirectMemoryParser {
    private JsonFactory jsonFactory = new JsonFactory();
    private static DirectMemoryParser INSTANCE = new DirectMemoryParser();

    private DirectMemoryParser() {
    }

    public static DirectMemoryParser instance() {
        return INSTANCE;
    }

    public DirectMemoryRequest buildRequest(InputStream inputStream) throws DirectMemoryException {
        try {
            JsonParser jp = this.jsonFactory.createJsonParser(inputStream);
            DirectMemoryRequest rq = new DirectMemoryRequest();
            JsonToken jsonToken = jp.nextToken();
            while (jsonToken != JsonToken.END_OBJECT && jsonToken != null) {
                String fieldName = jp.getCurrentName();
                if ("key".equals(fieldName)) {
                    rq.setKey(jp.getText());
                }
                if ("put".equals(fieldName)) {
                    rq.setUpdate(jp.getValueAsBoolean());
                }
                if ("expiresIn".equals(fieldName)) {
                    rq.setExpiresIn(jp.getValueAsInt());
                }
                if ("cacheContent".equals(fieldName)) {
                    jp.nextToken();
                    rq.setCacheContent(jp.getBinaryValue());
                }
                jsonToken = jp.nextToken();
            }
            jp.close();
            return rq;
        }
        catch (JsonParseException e) {
            throw new DirectMemoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DirectMemoryException(e.getMessage(), e);
        }
    }

    public DirectMemoryResponse buildResponse(InputStream inputStream) throws DirectMemoryException {
        try {
            JsonParser jp = this.jsonFactory.createJsonParser(inputStream);
            DirectMemoryResponse rs = new DirectMemoryResponse();
            JsonToken jsonToken = jp.nextToken();
            while (jsonToken != JsonToken.END_OBJECT && jsonToken != null) {
                String fieldName = jp.getCurrentName();
                if ("found".equals(fieldName)) {
                    rs.setFound(jp.getValueAsBoolean());
                }
                if ("key".equals(fieldName)) {
                    rs.setKey(jp.getText());
                }
                if ("cacheContent".equals(fieldName)) {
                    jp.nextToken();
                    rs.setCacheContent(jp.getBinaryValue());
                }
                jsonToken = jp.nextToken();
            }
            return rs;
        }
        catch (JsonParseException e) {
            throw new DirectMemoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DirectMemoryException(e.getMessage(), e);
        }
    }
}

