/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.producer;

import java.net.URL;
import org.apache.deltaspike.test.category.WebProfileCategory;
import org.apache.deltaspike.test.servlet.impl.producer.EarlyRequestInjectionFilter;
import org.apache.deltaspike.test.servlet.impl.util.ArchiveUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={WebProfileCategory.class})
public class EarlyRequestInjectionTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive getDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(EarlyRequestInjectionTest.class.getSimpleName() + ".war"))).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndServletModuleArchive())).addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml")).addClass(EarlyRequestInjectionFilter.class)).addAsWebResource((Asset)new StringAsset("foobar"), "foobar.txt")).setWebXML((Asset)new StringAsset(((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).filter(EarlyRequestInjectionFilter.class, new String[]{"/*"}).exportAsString()));
    }

    @Test
    public void shouldInjectRequestIntoFilters() throws Exception {
        String url = new URL(this.contextPath, "foobar.txt").toString();
        HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)new HttpGet(url));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] verificationHeader = response.getHeaders("X-DS-Request-Injected");
        Assert.assertEquals((long)1L, (long)verificationHeader.length);
        Assert.assertEquals((Object)"true", (Object)verificationHeader[0].getValue());
    }
}

