/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.resourceloader;

import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.resourceloader.InjectableResource;
import org.apache.deltaspike.servlet.api.resourceloader.WebResourceProvider;
import org.apache.deltaspike.test.category.WebProfileCategory;
import org.apache.deltaspike.test.servlet.impl.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={WebProfileCategory.class})
public class WebResourceProviderTest {
    @Inject
    @InjectableResource(location="/foobar.txt", resourceProvider=WebResourceProvider.class)
    private InputStream streamAbsolutePath;
    @Inject
    @InjectableResource(location="foobar.txt", resourceProvider=WebResourceProvider.class)
    private InputStream streamRelativePath;
    @Inject
    @InjectableResource(location="/foo/bar.txt", resourceProvider=WebResourceProvider.class)
    private InputStream streamDirectory;
    @Inject
    @InjectableResource(location="/foobar.properties", resourceProvider=WebResourceProvider.class)
    private Properties propertiesAbsolutePath;

    @Deployment
    public static WebArchive getDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(WebResourceProviderTest.class.getSimpleName() + ".war"))).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndServletModuleArchive())).addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml")).addAsWebResource((Asset)new StringAsset("foobar"), "foobar.txt")).addAsWebResource((Asset)new StringAsset("foobar"), "foo/bar.txt")).addAsWebResource((Asset)new StringAsset("foo=bar"), "foobar.properties");
    }

    @Test
    public void testStreamWithAbsolutePath() {
        Assert.assertNotNull((String)"Stream not injected", (Object)this.streamAbsolutePath);
    }

    @Test
    public void testStreamWithRelativePath() {
        Assert.assertNotNull((String)"Stream not injected", (Object)this.streamRelativePath);
    }

    @Test
    public void testStreamWithFileInDirectory() {
        Assert.assertNotNull((String)"Stream not injected", (Object)this.streamDirectory);
    }

    @Test
    public void testPropertiesWithAbsolutePath() {
        Assert.assertNotNull((String)"Properties not injected", (Object)this.propertiesAbsolutePath);
        Assert.assertEquals((Object)"bar", (Object)this.propertiesAbsolutePath.get("foo"));
    }
}

