/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.producer;

import java.net.URL;
import org.apache.deltaspike.test.category.WebProfileCategory;
import org.apache.deltaspike.test.servlet.impl.producer.ServletObjectInjectionBean;
import org.apache.deltaspike.test.servlet.impl.producer.ServletObjectInjectionServlet;
import org.apache.deltaspike.test.servlet.impl.util.ArchiveUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={WebProfileCategory.class})
public class ServletObjectInjectionTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive getDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ServletObjectInjectionTest.class.getSimpleName() + ".war"))).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndServletModuleArchive())).addClass(ServletObjectInjectionBean.class)).addClass(ServletObjectInjectionServlet.class)).addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml")).setWebXML((Asset)new StringAsset(((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).servlet(ServletObjectInjectionServlet.class, new String[]{"/servlet-object-injecetion"}).exportAsString()));
    }

    @Test
    public void shouldInjectServletRequest() throws Exception {
        Assert.assertThat((Object)this.responseFromServlet(), (Matcher)Matchers.containsString((String)"[ServletRequest=OK]"));
    }

    @Test
    public void shouldInjectHttpServletRequest() throws Exception {
        Assert.assertThat((Object)this.responseFromServlet(), (Matcher)Matchers.containsString((String)"[HttpServletRequest=OK]"));
    }

    @Test
    public void shouldInjectServletResponse() throws Exception {
        Assert.assertThat((Object)this.responseFromServlet(), (Matcher)Matchers.containsString((String)"[ServletResponse=OK]"));
    }

    @Test
    public void shouldInjectHttpServletResponse() throws Exception {
        Assert.assertThat((Object)this.responseFromServlet(), (Matcher)Matchers.containsString((String)"[HttpServletResponse=OK]"));
    }

    @Test
    public void shouldInjectHttpSession() throws Exception {
        Assert.assertThat((Object)this.responseFromServlet(), (Matcher)Matchers.containsString((String)"[HttpSession=OK]"));
    }

    private String responseFromServlet() throws Exception {
        String url = new URL(this.contextPath, "servlet-object-injecetion").toString();
        HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)new HttpGet(url));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }
}

